/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadExceptionTooBigFile;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.FileUploadThread;

class UploadFileData
implements FileData {
    private FileData fileData = null;
    private FileUploadThread fileUploadThread = null;
    private InputStream inputStream = null;
    private long uploadRemainingLength = -1L;
    private UploadPolicy uploadPolicy = null;
    private MessageDigest digest = null;
    private static final int BUFLEN = 4096;
    private static final byte[] buffer = new byte[4096];

    public UploadFileData(FileData fileDataParam, FileUploadThread fileUploadThreadParam, UploadPolicy uploadPolicyParam) {
        this.fileData = fileDataParam;
        this.fileUploadThread = fileUploadThreadParam;
        this.uploadPolicy = uploadPolicyParam;
    }

    long getRemainingLength() {
        return this.uploadRemainingLength;
    }

    String getMD5() {
        StringBuffer ret = new StringBuffer();
        byte[] md5sum = new byte[32];
        if (this.digest != null) {
            md5sum = this.digest.digest();
        }
        for (int i = 0; i < md5sum.length; ++i) {
            ret.append(Integer.toHexString(md5sum[i] >> 4 & 0xF));
            ret.append(Integer.toHexString(md5sum[i] & 0xF));
        }
        return ret.toString();
    }

    void uploadFile(OutputStream outputStream, long amount) throws JUploadException {
        this.uploadPolicy.displayDebug("in UploadFileData.uploadFile (amount:" + amount + ", getUploadLength(): " + this.getUploadLength() + ")", 30);
        this.getInputStream();
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new JUploadException(e);
        }
        while (!this.fileUploadThread.isUploadStopped() && 0L < amount) {
            int toread = amount > 4096L ? 4096 : (int)amount;
            int towrite = 0;
            try {
                towrite = this.inputStream.read(buffer, 0, toread);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new JUploadIOException(e);
            }
            if (towrite <= 0) continue;
            this.digest.update(buffer, 0, towrite);
            try {
                outputStream.write(buffer, 0, towrite);
                this.fileUploadThread.nbBytesUploaded(towrite);
                amount -= (long)towrite;
                this.uploadRemainingLength -= (long)towrite;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new JUploadIOException(e);
            }
        }
    }

    public void afterUpload() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                this.uploadPolicy.displayWarn(e.getClass().getName() + ": " + e.getMessage() + " (in UploadFileData.afterUpload()");
            }
            this.inputStream = null;
        }
        this.fileData.afterUpload();
    }

    public void beforeUpload() throws JUploadException {
        this.fileData.beforeUpload();
        this.uploadRemainingLength = this.fileData.getUploadLength();
    }

    public boolean canRead() {
        return this.fileData.canRead();
    }

    public String getDirectory() {
        return this.fileData.getDirectory();
    }

    public File getFile() {
        return this.fileData.getFile();
    }

    public String getFileExtension() {
        return this.fileData.getFileExtension();
    }

    public long getFileLength() {
        return this.fileData.getFileLength();
    }

    public String getFileName() {
        return this.fileData.getFileName();
    }

    public InputStream getInputStream() throws JUploadException {
        if (this.inputStream == null) {
            if (this.uploadRemainingLength <= 0L) {
                this.uploadPolicy.displayWarn("[" + this.getFileName() + "] UploadFileData.getInputStream(): uploadRemainingLength is <= 0. Trying a new upload ?");
                this.uploadRemainingLength = this.fileData.getUploadLength();
            }
            this.inputStream = this.fileData.getInputStream();
        }
        return this.inputStream;
    }

    public Date getLastModified() {
        return this.fileData.getLastModified();
    }

    public String getMimeType() {
        return this.fileData.getMimeType();
    }

    public String getUploadFilename(int index) throws JUploadException {
        return this.uploadPolicy.getUploadFilename(this.fileData, index);
    }

    public String getUploadName(int index) {
        return this.uploadPolicy.getUploadName(this.fileData, index);
    }

    public long getUploadLength() throws JUploadException {
        long uploadLength = this.fileData.getUploadLength();
        if (uploadLength > this.uploadPolicy.getMaxFileSize()) {
            throw new JUploadExceptionTooBigFile(this.fileData.getFileName(), this.fileData.getUploadLength(), this.uploadPolicy);
        }
        return uploadLength;
    }

    public String getRelativeDir() {
        return this.fileData.getRelativeDir();
    }
}

