/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.FileUploadThreadHTTP;
import wjhk.jupload2.upload.InteractiveTrustManager;

public class HttpConnect {
    private UploadPolicy uploadPolicy;

    private Socket HttpProxyConnect(Proxy proxy, String host, int port) throws UnknownHostException, IOException, ConnectException {
        InetSocketAddress sa = (InetSocketAddress)proxy.address();
        String phost = sa.isUnresolved() ? sa.getHostName() : sa.getAddress().getHostAddress();
        int pport = sa.getPort();
        Socket proxysock = new Socket(phost, pport);
        String req = "CONNECT " + host + ":" + port + " HTTP/1.1\r\n\r\n";
        proxysock.getOutputStream().write(req.getBytes());
        BufferedReader proxyIn = new BufferedReader(new InputStreamReader(proxysock.getInputStream()));
        String line = proxyIn.readLine();
        if (!line.matches("^HTTP/\\d\\.\\d\\s200\\s.*")) {
            throw new ConnectException("Proxy response: " + line);
        }
        this.uploadPolicy.displayDebug("Proxy response: " + line, 40);
        proxyIn.readLine();
        return proxysock;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Socket Connect(URL url, Proxy proxy) throws NoSuchAlgorithmException, KeyManagementException, ConnectException, UnknownHostException, IOException, KeyStoreException, CertificateException, IllegalArgumentException, UnrecoverableKeyException {
        int port;
        boolean useProxy;
        Socket ret = null;
        String host = url.getHost();
        boolean bl = useProxy = proxy != null && proxy.type() != Proxy.Type.DIRECT;
        if (url.getProtocol().equals("https")) {
            int port2 = -1 == url.getPort() ? 443 : url.getPort();
            SSLContext context = SSLContext.getInstance("SSL");
            InteractiveTrustManager tm = new InteractiveTrustManager(this.uploadPolicy, url.getHost(), null);
            context.init(tm.getKeyManagers(), tm.getTrustManagers(), SecureRandom.getInstance("SHA1PRNG"));
            if (useProxy) {
                if (proxy.type() == Proxy.Type.HTTP) {
                    this.uploadPolicy.displayDebug("Using SSL socket, via HTTP proxy", 20);
                    return context.getSocketFactory().createSocket(this.HttpProxyConnect(proxy, host, port2), host, port2, true);
                }
                if (proxy.type() != Proxy.Type.SOCKS) throw new ConnectException("Unkown proxy type " + (Object)((Object)proxy.type()));
                this.uploadPolicy.displayDebug("Using SSL socket, via SOCKS proxy", 20);
                Socket tsock = new Socket(proxy);
                tsock.connect(new InetSocketAddress(host, port2));
                return context.getSocketFactory().createSocket(tsock, host, port2, true);
            }
            this.uploadPolicy.displayDebug("Using SSL socket, direct connection", 20);
            return context.getSocketFactory().createSocket(host, port2);
        }
        int n = port = -1 == url.getPort() ? 80 : url.getPort();
        if (useProxy) {
            if (proxy.type() == Proxy.Type.HTTP) {
                InetSocketAddress sa = (InetSocketAddress)proxy.address();
                host = sa.isUnresolved() ? sa.getHostName() : sa.getAddress().getHostAddress();
                port = sa.getPort();
                this.uploadPolicy.displayDebug("Using non SSL socket, proxy=" + host + ":" + port, 20);
                return new Socket(host, port);
            }
            if (proxy.type() != Proxy.Type.SOCKS) throw new ConnectException("Unkown proxy type " + (Object)((Object)proxy.type()));
            this.uploadPolicy.displayDebug("Using non SSL socket, via SOCKS proxy", 20);
            Socket tsock = new Socket(proxy);
            tsock.connect(new InetSocketAddress(host, port));
            return tsock;
        }
        this.uploadPolicy.displayDebug("Using non SSL socket, direct connection", 20);
        return new Socket(host, port);
    }

    public Socket Connect(URL url) throws NoSuchAlgorithmException, KeyManagementException, ConnectException, UnknownHostException, IOException, URISyntaxException, KeyStoreException, CertificateException, IllegalArgumentException, UnrecoverableKeyException {
        Proxy proxy = ProxySelector.getDefault().select(url.toURI()).get(0);
        return this.Connect(url, proxy);
    }

    public String getProtocol() throws URISyntaxException, KeyManagementException, NoSuchAlgorithmException, UnknownHostException, KeyStoreException, CertificateException, IllegalArgumentException, UnrecoverableKeyException, IOException {
        URL url = new URL(this.uploadPolicy.getPostURL());
        Proxy proxy = ProxySelector.getDefault().select(url.toURI()).get(0);
        boolean useProxy = proxy != null && proxy.type() != Proxy.Type.DIRECT;
        boolean useSSL = url.getProtocol().equals("https");
        Socket s = this.Connect(url, proxy);
        InputStream in = s.getInputStream();
        StringBuffer req = new StringBuffer();
        req.append("HEAD ");
        if (useProxy && !useSSL) {
            req.append(url.getProtocol()).append("://").append(url.getHost());
        }
        req.append(url.getPath());
        req.append(" ").append("HTTP/1.1").append("\r\n");
        req.append("Host: ").append(url.getHost()).append("\r\n");
        req.append("Connection: close\r\n\r\n");
        OutputStream os = s.getOutputStream();
        os.write(req.toString().getBytes());
        os.flush();
        if (!(s instanceof SSLSocket)) {
            s.shutdownOutput();
        }
        String firstLine = FileUploadThreadHTTP.readLine(in, "US-ASCII", false);
        String nextLine = FileUploadThreadHTTP.readLine(in, "US-ASCII", false);
        while ((nextLine = FileUploadThreadHTTP.readLine(in, "US-ASCII", false)).length() > 0) {
            if (!nextLine.matches("^Server: .*IIS")) continue;
            try {
                this.uploadPolicy.setProperty("allowHttpPersistent", "false");
                this.uploadPolicy.displayWarn("allowHttpPersistent' forced to false, for IIS compatibility (in HttpConnect.getProtocol())");
                break;
            }
            catch (JUploadException e) {
                this.uploadPolicy.displayWarn("Can't set property 'allowHttpPersistent' to false, in HttpConnect.getProtocol()");
                break;
            }
        }
        s.close();
        if (null == firstLine) {
            this.uploadPolicy.displayErr("EMPTY HEAD response");
            return "HTTP/1.1";
        }
        Matcher m = Pattern.compile("^(HTTP/\\d\\.\\d)\\s.*").matcher(firstLine);
        if (!m.matches()) {
            this.uploadPolicy.displayErr("Unexpected HEAD response: '" + firstLine + "'");
            return "HTTP/1.1";
        }
        this.uploadPolicy.displayDebug("HEAD response: " + firstLine, 40);
        return m.group(1);
    }

    public HttpConnect(UploadPolicy policy) {
        this.uploadPolicy = policy;
    }
}

