/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.applet.Applet;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSocket;
import javax.swing.JProgressBar;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.CookieJar;
import wjhk.jupload2.upload.DefaultFileUploadThread;
import wjhk.jupload2.upload.HttpConnect;

public class FileUploadThreadHTTP
extends DefaultFileUploadThread {
    private static final String DUMMYMD5 = "DUMMYMD5DUMMYMD5DUMMYMD5DUMMYMD5";
    private static final int CHUNKBUF_SIZE = 4096;
    private static final Pattern pChunked = Pattern.compile("^Transfer-Encoding:\\s+chunked", 2);
    private static final Pattern pClose = Pattern.compile("^Connection:\\s+close", 2);
    private static final Pattern pProxyClose = Pattern.compile("^Proxy-Connection:\\s+close", 2);
    private static final Pattern pHttpStatus = Pattern.compile("^HTTP/\\d\\.\\d\\s+((\\d+)\\s+.*)$");
    private static final Pattern pContentLen = Pattern.compile("^Content-Length:\\s+(\\d+)$", 2);
    private static final Pattern pContentTypeCs = Pattern.compile("^Content-Type:\\s+.*;\\s*charset=([^;\\s]+).*$", 2);
    private static final Pattern pSetCookie = Pattern.compile("^Set-Cookie:\\s+(.*)$", 2);
    private final byte[] chunkbuf = new byte[4096];
    private CookieJar cookies = new CookieJar();
    private String boundary = "-----------------------------" + this.getRandomString();
    private String[] heads = null;
    private String[] tails = null;
    private DataOutputStream httpDataOut = null;
    private Socket sock = null;
    private InputStream httpDataIn = null;
    private StringBuffer sbHttpResponseBody = null;

    public FileUploadThreadHTTP(FileData[] filesDataParam, UploadPolicy uploadPolicy, JProgressBar progress) {
        super(filesDataParam, uploadPolicy, progress);
        uploadPolicy.displayDebug("Upload done by using the " + this.getClass().getName() + " class", 40);
        this.setName("FileUploadThreadHTTP");
        this.heads = new String[filesDataParam.length];
        this.tails = new String[filesDataParam.length];
    }

    void beforeRequest(int firstFileToUploadParam, int nbFilesToUploadParam) throws JUploadException {
        this.setAllHead(firstFileToUploadParam, nbFilesToUploadParam, this.boundary);
        this.setAllTail(firstFileToUploadParam, nbFilesToUploadParam, this.boundary);
    }

    long getAdditionnalBytesForUpload(int index) {
        return this.heads[index].length() + this.tails[index].length();
    }

    void afterFile(int index) throws JUploadException {
        try {
            String tail = this.tails[index].replaceFirst(DUMMYMD5, this.filesToUpload[index].getMD5());
            this.httpDataOut.writeBytes(tail);
            this.uploadPolicy.displayDebug("--- filetail start (len=" + tail.length() + "):", 80);
            this.uploadPolicy.displayDebug(this.quoteCRLF(tail), 80);
            this.uploadPolicy.displayDebug("--- filetail end", 80);
        }
        catch (Exception e) {
            throw new JUploadException(e);
        }
    }

    void beforeFile(int index) throws JUploadException {
        try {
            this.httpDataOut.writeBytes(this.heads[index]);
            this.uploadPolicy.displayDebug("--- fileheader start (len=" + this.heads[index].length() + "):", 80);
            this.uploadPolicy.displayDebug(this.quoteCRLF(this.heads[index]), 80);
            this.uploadPolicy.displayDebug("--- fileheader end", 80);
        }
        catch (Exception e) {
            throw new JUploadException(e);
        }
    }

    void cleanAll() throws JUploadException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanRequest() throws JUploadException {
        JUploadException localException = null;
        try {
            this.httpDataOut.close();
        }
        catch (NullPointerException e) {
        }
        catch (IOException e) {
            localException = new JUploadException(e);
            this.uploadPolicy.displayErr(this.uploadPolicy.getString("errDuringUpload"), e);
        }
        finally {
            this.httpDataOut = null;
        }
        try {
            this.httpDataIn.close();
        }
        catch (NullPointerException e) {
        }
        catch (IOException e) {
            if (localException != null) {
                localException = new JUploadException(e);
                this.uploadPolicy.displayErr(this.uploadPolicy.getString("errDuringUpload"), localException);
            }
        }
        finally {
            this.httpDataIn = null;
        }
        try {
            this.sock.close();
        }
        catch (NullPointerException e) {
        }
        catch (IOException e) {
            if (localException != null) {
                localException = new JUploadException(e);
                this.uploadPolicy.displayErr(this.uploadPolicy.getString("errDuringUpload"), e);
            }
        }
        finally {
            this.sock = null;
        }
        if (localException != null) {
            throw localException;
        }
    }

    int finishRequest() throws JUploadException {
        boolean readingHttpBody = false;
        boolean gotClose = false;
        boolean gotChunked = false;
        boolean gotContentLength = false;
        int status = 0;
        int clen = 0;
        String line = "";
        byte[] body = new byte[]{};
        String charset = "ISO-8859-1";
        this.sbHttpResponseBody = new StringBuffer();
        try {
            if (this.stop && !(this.sock instanceof SSLSocket)) {
                this.sock.shutdownOutput();
            }
            while (!(this.stop || gotContentLength && clen <= 0)) {
                Matcher m;
                if (readingHttpBody) {
                    byte[] lbuf;
                    if (gotChunked) {
                        line = FileUploadThreadHTTP.readLine(this.httpDataIn, "US-ASCII", false);
                        if (null == line) {
                            throw new JUploadException("unexpected EOF");
                        }
                        int len = Integer.parseInt(line.replaceFirst(";.*", "").trim(), 16);
                        this.uploadPolicy.displayDebug("Chunk: " + line + " dec: " + len, 80);
                        if (len == 0) break;
                        while (len > 0) {
                            int ofs;
                            int res;
                            int rlen = len > 4096 ? 4096 : len;
                            if (rlen <= 0) continue;
                            for (ofs = 0; ofs < rlen; ofs += res) {
                                res = this.httpDataIn.read(this.chunkbuf, ofs, rlen - ofs);
                                if (res < 0) {
                                    throw new JUploadException("unexpected EOF");
                                }
                                len -= res;
                            }
                            if (ofs < rlen) {
                                throw new JUploadException("short read");
                            }
                            if (rlen < 4096) {
                                body = FileUploadThreadHTTP.byteAppend(body, this.chunkbuf, rlen);
                                continue;
                            }
                            body = FileUploadThreadHTTP.byteAppend(body, this.chunkbuf);
                        }
                        FileUploadThreadHTTP.readLine(this.httpDataIn, false);
                        continue;
                    }
                    if (gotContentLength) {
                        while (clen > 0) {
                            int ofs;
                            int res;
                            int rlen = clen > 4096 ? 4096 : clen;
                            if (rlen <= 0) continue;
                            for (ofs = 0; ofs < rlen; ofs += res) {
                                res = this.httpDataIn.read(this.chunkbuf, ofs, rlen - ofs);
                                if (res < 0) {
                                    throw new JUploadException("unexpected EOF");
                                }
                                clen -= res;
                            }
                            if (ofs < rlen) {
                                throw new JUploadException("short read");
                            }
                            if (rlen < 4096) {
                                body = FileUploadThreadHTTP.byteAppend(body, this.chunkbuf, rlen);
                                continue;
                            }
                            body = FileUploadThreadHTTP.byteAppend(body, this.chunkbuf);
                        }
                        continue;
                    }
                    while (null != (lbuf = FileUploadThreadHTTP.readLine(this.httpDataIn, true))) {
                        body = FileUploadThreadHTTP.byteAppend(body, lbuf);
                    }
                    break;
                }
                String tmp = FileUploadThreadHTTP.readLine(this.httpDataIn, "US-ASCII", false);
                if (null == tmp) {
                    throw new JUploadException("unexpected EOF");
                }
                if (status == 0) {
                    this.uploadPolicy.displayDebug("-------- Response Headers Start --------", 80);
                    m = pHttpStatus.matcher(tmp);
                    if (m.matches()) {
                        status = Integer.parseInt(m.group(2));
                        this.setResponseMsg(m.group(1));
                    } else {
                        this.uploadPolicy.displayDebug("First line of response: '" + tmp + "'", 80);
                        throw new JUploadException("HTTP response did not begin with status line.");
                    }
                }
                line = tmp.startsWith(" ") || tmp.startsWith("\t") ? line + " " + tmp.trim() : tmp;
                this.uploadPolicy.displayDebug(line, 80);
                if (pClose.matcher(line).matches()) {
                    gotClose = true;
                }
                if (pProxyClose.matcher(line).matches()) {
                    gotClose = true;
                }
                if (pChunked.matcher(line).matches()) {
                    gotChunked = true;
                }
                if ((m = pContentLen.matcher(line)).matches()) {
                    gotContentLength = true;
                    clen = Integer.parseInt(m.group(1));
                }
                if ((m = pContentTypeCs.matcher(line)).matches()) {
                    charset = m.group(1);
                }
                if ((m = pSetCookie.matcher(line)).matches()) {
                    this.cookies.parseCookieHeader(m.group(1));
                }
                if (line.length() != 0) continue;
                readingHttpBody = true;
                this.uploadPolicy.displayDebug("--------- Response Headers End ---------", 80);
            }
            if (gotClose) {
                this.cleanRequest();
            }
            this.sbHttpResponseBody.append(new String(body, charset));
        }
        catch (JUploadException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JUploadException(e);
        }
        return status;
    }

    String getResponseBody() {
        return this.sbHttpResponseBody.toString();
    }

    OutputStream getOutputStream() throws JUploadException {
        return this.httpDataOut;
    }

    void startRequest(long contentLength, boolean bChunkEnabled, int chunkPart, boolean bLastChunk) throws JUploadException {
        StringBuffer header = new StringBuffer();
        try {
            String chunkHttpParam = "jupart=" + chunkPart + "&jufinal=" + (bLastChunk ? "1" : "0");
            this.uploadPolicy.displayDebug("chunkHttpParam: " + chunkHttpParam, 40);
            URL url = new URL(this.uploadPolicy.getPostURL());
            if (bChunkEnabled) {
                url = null != url.getQuery() && !"".equals(url.getQuery()) ? new URL(url.toExternalForm() + "&" + chunkHttpParam) : new URL(url.toExternalForm() + "?" + chunkHttpParam);
            }
            Proxy proxy = null;
            proxy = ProxySelector.getDefault().select(url.toURI()).get(0);
            boolean useProxy = proxy != null && proxy.type() != Proxy.Type.DIRECT;
            boolean useSSL = url.getProtocol().equals("https");
            header.setLength(0);
            header.append("POST ");
            if (useProxy && !useSSL) {
                header.append(url.getProtocol()).append("://").append(url.getHost());
            }
            header.append(url.getPath());
            if (null != url.getQuery() && !"".equals(url.getQuery())) {
                header.append("?").append(url.getQuery());
            }
            header.append(" ").append(this.uploadPolicy.getServerProtocol()).append("\r\n");
            header.append("Host: ").append(url.getHost()).append("\r\nAccept: */*\r\n");
            header.append("Accept-Encoding: identity\r\n");
            if (!this.uploadPolicy.getAllowHttpPersistent()) {
                header.append("Connection: close\r\n");
            } else if (!bChunkEnabled || bLastChunk || useProxy || !this.uploadPolicy.getServerProtocol().equals("HTTP/1.1")) {
                header.append("Connection: close\r\n");
            } else {
                header.append("Keep-Alive: 300\r\n");
                if (useProxy) {
                    header.append("Proxy-Connection: keep-alive\r\n");
                } else {
                    header.append("Connection: keep-alive\r\n");
                }
            }
            String formParams = this.getFormParamsForPostRequest(url);
            header.append("Content-Type: multipart/form-data; boundary=").append(this.boundary.substring(2)).append("\r\n");
            header.append("Content-Length: ").append(contentLength += (long)formParams.length()).append("\r\n");
            this.uploadPolicy.onAppendHeader(header);
            header.append("\r\n");
            header.append(formParams);
            if (this.sock == null || !this.uploadPolicy.getAllowHttpPersistent()) {
                this.sock = new HttpConnect(this.uploadPolicy).Connect(url, proxy);
                this.httpDataOut = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
                this.httpDataIn = this.sock.getInputStream();
            }
            this.httpDataOut.writeBytes(header.toString());
        }
        catch (Exception e) {
            throw new JUploadException(e);
        }
        if (this.uploadPolicy.getDebugLevel() >= 80) {
            this.uploadPolicy.displayDebug("=== main header (len=" + header.length() + "):\n" + this.quoteCRLF(header.toString()), 80);
            this.uploadPolicy.displayDebug("=== main header end", 80);
        }
    }

    private final String getRandomString() {
        StringBuffer sbRan = new StringBuffer(11);
        String alphaNum = "1234567890abcdefghijklmnopqrstuvwxyz";
        for (int i = 0; i < 11; ++i) {
            int num = (int)(Math.random() * (double)(alphaNum.length() - 1));
            sbRan.append(alphaNum.charAt(num));
        }
        return sbRan.toString();
    }

    private final StringBuffer addPostVariable(String bound, String name, String value) {
        StringBuffer sb = new StringBuffer();
        return sb.append(bound).append("\r\n").append("Content-Disposition: form-data; name=\"").append(name).append("\"\r\nContent-Transfer-Encoding: 8bit\r\n\r\n").append(value).append("\r\n");
    }

    private final StringBuffer addFormVariables(String bound, String formname) throws JUploadException {
        StringBuffer sb = new StringBuffer();
        try {
            JSObject win = JSObject.getWindow((Applet)this.uploadPolicy.getApplet());
            Object o = win.eval("document." + formname + ".elements.length");
            if (o instanceof Number) {
                int len = ((Number)o).intValue();
                if (len <= 0) {
                    this.uploadPolicy.displayWarn("The specified form \"" + formname + "\" does not contain any elements.");
                }
                for (int i = 0; i < len; ++i) {
                    try {
                        Object on;
                        String t;
                        Object name = win.eval("document." + formname + "[" + i + "].name");
                        Object value = win.eval("document." + formname + "[" + i + "].value");
                        Object etype = win.eval("document." + formname + "[" + i + "].type");
                        if (etype instanceof String && ((t = (String)etype).equals("checkbox") || t.equals("radio")) && (on = win.eval("document." + formname + "[" + i + "].checked")) instanceof Boolean && !((Boolean)on).booleanValue() || !(name instanceof String) || !(value instanceof String)) continue;
                        sb.append(this.addPostVariable(bound, (String)name, (String)value));
                        continue;
                    }
                    catch (Exception e1) {
                        if (!(e1 instanceof JSException)) {
                            throw new JUploadException(e1);
                        }
                        this.uploadPolicy.displayDebug(e1.getStackTrace()[1] + ": got JSException, bailing out", 80);
                        i = len;
                    }
                }
            } else {
                this.uploadPolicy.displayWarn("The specified form \"" + formname + "\" could not be found.");
            }
        }
        catch (Exception e) {
            if (e instanceof JSException) {
                this.uploadPolicy.displayDebug(e.getStackTrace()[1] + ": No JavaScript availabe", 80);
            }
            throw new JUploadException(e);
        }
        return sb;
    }

    private final String getFileHeader(int index, String bound, int chunkPart) throws JUploadException {
        String filenameEncoding = this.uploadPolicy.getFilenameEncoding();
        String mimetype = this.filesToUpload[index].getMimeType();
        String uploadFilename = this.filesToUpload[index].getUploadFilename(index);
        StringBuffer sb = new StringBuffer();
        String form = this.uploadPolicy.getFormdata();
        if (null != form) {
            sb.append(this.addFormVariables(bound, form));
        }
        sb.append(this.addPostVariable(bound, "mimetype[]", mimetype));
        sb.append(this.addPostVariable(bound, "pathinfo[]", this.filesToUpload[index].getDirectory()));
        sb.append(this.addPostVariable(bound, "relpathinfo[]", this.filesToUpload[index].getRelativeDir()));
        sb.append(bound).append("\r\n");
        sb.append("Content-Disposition: form-data; name=\"").append(this.filesToUpload[index].getUploadName(index)).append("\"; filename=\"");
        if (filenameEncoding == null) {
            sb.append(uploadFilename);
        } else {
            try {
                this.uploadPolicy.displayDebug("Encoded filename: " + URLEncoder.encode(uploadFilename, filenameEncoding), 99);
                sb.append(URLEncoder.encode(uploadFilename, filenameEncoding));
            }
            catch (UnsupportedEncodingException e) {
                this.uploadPolicy.displayWarn(e.getClass().getName() + ": " + e.getMessage() + " (in UploadFileData.getFileHeader)");
                sb.append(uploadFilename);
            }
        }
        sb.append("\"\r\n");
        sb.append("Content-Type: ").append(mimetype).append("\r\n");
        sb.append("\r\n");
        return sb.toString();
    }

    private final void setAllHead(int firstFileToUpload, int nbFilesToUpload, String bound) throws JUploadException {
        for (int i = 0; i < nbFilesToUpload; ++i) {
            this.heads[i] = this.getFileHeader(firstFileToUpload + i, bound, -1);
        }
    }

    private final void setAllTail(int firstFileToUpload, int nbFilesToUpload, String bound) {
        for (int i = 0; i < nbFilesToUpload; ++i) {
            this.tails[firstFileToUpload + i] = "\r\n" + this.addPostVariable(bound, "md5sum[]", DUMMYMD5);
        }
        if (nbFilesToUpload > 0) {
            int n = firstFileToUpload + nbFilesToUpload - 1;
            this.tails[n] = this.tails[n] + bound + "--\r\n";
        }
    }

    private final String quoteCRLF(String s) {
        return s.replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n\n");
    }

    private final String getFormParamsForPostRequest(URL url) {
        StringBuffer formParams = new StringBuffer();
        String query = url.getQuery();
        if (null != query) {
            String[] paramPairs;
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            for (String param : paramPairs = query.split("&")) {
                if (!param.contains("=")) continue;
                requestParameters.put(param.split("=")[0], param.split("=")[1]);
            }
            for (String key : requestParameters.keySet()) {
                formParams.append(this.addPostVariable(this.boundary, key, (String)requestParameters.get(key)));
            }
        }
        return formParams.toString();
    }

    public static String readLine(InputStream inputStream, String charset, boolean includeCR) throws IOException {
        byte[] line = FileUploadThreadHTTP.readLine(inputStream, includeCR);
        return null == line ? null : new String(line, charset);
    }

    public static byte[] readLine(InputStream inputStream, boolean includeCR) throws IOException {
        int len = 0;
        int buflen = 128;
        byte[] buf = new byte[buflen];
        byte[] ret = null;
        while (true) {
            int b = inputStream.read();
            switch (b) {
                case -1: {
                    if (len > 0) {
                        ret = new byte[len];
                        System.arraycopy(buf, 0, ret, 0, len);
                        return ret;
                    }
                    return null;
                }
                case 10: {
                    if (len <= 0 || buf[len - 1] != 13) break;
                    if (includeCR) {
                        ret = new byte[len + 1];
                        if (len > 0) {
                            System.arraycopy(buf, 0, ret, 0, len);
                        }
                        ret[len] = 10;
                    } else {
                        ret = new byte[--len];
                        if (len > 0) {
                            System.arraycopy(buf, 0, ret, 0, len);
                        }
                    }
                    return ret;
                }
            }
            buf[len++] = (byte)b;
            if (len < buflen) continue;
            byte[] tmp = new byte[buflen *= 2];
            System.arraycopy(buf, 0, tmp, 0, len);
            buf = tmp;
        }
    }

    public static byte[] byteAppend(byte[] buf1, byte[] buf2) {
        byte[] ret = new byte[buf1.length + buf2.length];
        System.arraycopy(buf1, 0, ret, 0, buf1.length);
        System.arraycopy(buf2, 0, ret, buf1.length, buf2.length);
        return ret;
    }

    public static byte[] byteAppend(byte[] buf1, byte[] buf2, int len) {
        if (len > buf2.length) {
            len = buf2.length;
        }
        byte[] ret = new byte[buf1.length + len];
        System.arraycopy(buf1, 0, ret, 0, buf1.length);
        System.arraycopy(buf2, 0, ret, buf1.length, len);
        return ret;
    }
}

