/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;
import java.awt.Point;
import java.io.File;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumnModel;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.gui.FilePanel;
import wjhk.jupload2.gui.FilePanelDataModel2;
import wjhk.jupload2.gui.FilePanelJTable;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.policies.UploadPolicy;

public class FilePanelTableImp
extends Panel
implements FilePanel {
    private static final long serialVersionUID = -8273990467324350526L;
    private FilePanelJTable jtable;
    private FilePanelDataModel2 model;

    public FilePanelTableImp(JUploadPanel jup, UploadPolicy uploadPolicy) {
        this.setLayout(new BorderLayout());
        this.addMouseListener(jup);
        this.jtable = new FilePanelJTable(jup, uploadPolicy);
        this.model = new FilePanelDataModel2(uploadPolicy);
        this.jtable.setModel(this.model);
        TableColumnModel colModel = this.jtable.getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            colModel.getColumn(i).setPreferredWidth(this.model.getColumnSize(i));
        }
        JScrollPane scrollPane = new JScrollPane(this.jtable);
        this.add((Component)scrollPane, "Center");
        scrollPane.addMouseListener(jup);
    }

    public final void addFiles(File[] f, File root) {
        if (null != f) {
            for (int i = 0; i < f.length; ++i) {
                this.addDirectoryFiles(f[i], root);
            }
        }
    }

    private final void addDirectoryFiles(File f, File root) {
        if (!f.isDirectory()) {
            this.addFileOnly(f, root);
        } else {
            File[] dirFiles = f.listFiles();
            for (int i = 0; i < dirFiles.length; ++i) {
                if (dirFiles[i].isDirectory()) {
                    this.addDirectoryFiles(dirFiles[i], root);
                    continue;
                }
                this.addFileOnly(dirFiles[i], root);
            }
        }
    }

    private final void addFileOnly(File f, File root) {
        if (!this.model.contains(f)) {
            this.model.addFile(f, root);
        }
    }

    public final FileData[] getFiles() {
        FileData[] files = new FileData[this.getFilesLength()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = this.model.getFileDataAt(i);
        }
        return files;
    }

    public final int getFilesLength() {
        return this.jtable.getRowCount();
    }

    public final void removeSelected() {
        int[] rows = this.jtable.getSelectedRows();
        for (int i = rows.length - 1; 0 <= i; --i) {
            this.model.removeRow(rows[i]);
        }
    }

    public final void removeAll() {
        for (int i = this.getFilesLength() - 1; 0 <= i; --i) {
            this.model.removeRow(i);
        }
    }

    public final void remove(FileData fileData) {
        this.model.removeRow(fileData);
    }

    public final void clearSelection() {
        this.jtable.clearSelection();
    }

    public final void focusTable() {
        if (0 < this.jtable.getRowCount()) {
            this.jtable.requestFocus();
        }
    }

    public FileData getFileDataAt(Point point) {
        int row = this.jtable.rowAtPoint(point);
        return this.model.getFileDataAt(row);
    }

    public Component getDropComponent() {
        return this;
    }
}

