/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import wjhk.jupload2.policies.UploadPolicy;

public class SizeRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -2029129064667754146L;
    private static final double gB = 1.073741824E9;
    private static final double mB = 1048576.0;
    private static final double kB = 1024.0;
    private String sizeunit_gigabytes;
    private String sizeunit_megabytes;
    private String sizeunit_kilobytes;
    private String sizeunit_bytes;

    public SizeRenderer(UploadPolicy uploadPolicy) {
        this.sizeunit_gigabytes = uploadPolicy.getString("unitGigabytes");
        this.sizeunit_megabytes = uploadPolicy.getString("unitMegabytes");
        this.sizeunit_kilobytes = uploadPolicy.getString("unitKilobytes");
        this.sizeunit_bytes = uploadPolicy.getString("unitBytes");
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof Long) {
            double d = ((Long)value).doubleValue();
            String unit = this.sizeunit_bytes;
            if (d >= 1.073741824E9) {
                d /= 1.073741824E9;
                unit = this.sizeunit_gigabytes;
            } else if (d >= 1048576.0) {
                d /= 1048576.0;
                unit = this.sizeunit_megabytes;
            } else if (d >= 1024.0) {
                d /= 1024.0;
                unit = this.sizeunit_kilobytes;
            }
            this.setValue(String.format("%1$,3.2f %2$s", new Double(d), unit));
            super.setHorizontalAlignment(4);
        }
        return cell;
    }
}

