/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;
import wjhk.jupload2.gui.IconWorker;
import wjhk.jupload2.policies.DefaultUploadPolicy;
import wjhk.jupload2.policies.PictureUploadPolicy;
import wjhk.jupload2.policies.UploadPolicy;

public class JUploadFileView
extends FileView
implements PropertyChangeListener,
ThreadFactory {
    static ThreadGroup iconWorkerThreadGroup = new ThreadGroup("JUpload ThreadGroup");
    UploadPolicy uploadPolicy = null;
    JFileChooser fileChooser = null;
    ConcurrentHashMap<String, IconWorker> hashMap = new ConcurrentHashMap();
    ExecutorService executorService = null;
    public static ImageIcon emptyIcon = null;

    public JUploadFileView(UploadPolicy uploadPolicy, JFileChooser fileChooser) {
        this.uploadPolicy = uploadPolicy;
        this.fileChooser = fileChooser;
        this.fileChooser.addPropertyChangeListener(this);
        iconWorkerThreadGroup.setMaxPriority(1);
        if (emptyIcon == null || emptyIcon.getIconHeight() != uploadPolicy.getFileChooserIconSize()) {
            emptyIcon = new ImageIcon(new BufferedImage(uploadPolicy.getFileChooserIconSize(), uploadPolicy.getFileChooserIconSize(), 3));
        }
    }

    synchronized void execute(IconWorker iconWorker) {
        this.uploadPolicy.displayDebug("[JUploadFileView.execute] Adding " + iconWorker.file.getAbsolutePath(), 90);
        if (this.executorService == null || this.executorService.isShutdown()) {
            this.uploadPolicy.displayDebug("JUploadFileView.execute: creating the executorService", 90);
            this.executorService = Executors.newSingleThreadExecutor();
        }
        iconWorker.status = 3;
        this.executorService.execute(iconWorker);
    }

    public synchronized void shutdownNow() {
        if (this.executorService != null) {
            this.stopRunningJobs();
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    private void stopRunningJobs() {
        this.uploadPolicy.displayDebug("Shutting down all IconWorker running jobs", 50);
        Enumeration<IconWorker> e = this.hashMap.elements();
        IconWorker iw = null;
        while (e.hasMoreElements()) {
            iw = e.nextElement();
            if (iw.status != 3) continue;
            this.uploadPolicy.displayDebug("   Shutting down " + iw.file.getAbsolutePath(), 50);
            iw.status = 4;
        }
        this.uploadPolicy.displayDebug("All IconWorker running jobs are now marked as stopped.", 50);
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.uploadPolicy.displayDebug("[JUploadFileView] Directory changed", 80);
            this.stopRunningJobs();
        }
    }

    public String getDescription(File f) {
        return null;
    }

    public Icon getIcon(File file) {
        if (!(this.uploadPolicy.getFileChooserIconFromFileContent() == 1 && this.uploadPolicy instanceof DefaultUploadPolicy || this.uploadPolicy.getFileChooserIconFromFileContent() == 0 && this.uploadPolicy instanceof PictureUploadPolicy)) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        IconWorker iconWorker = this.hashMap.get(file.getAbsolutePath());
        if (iconWorker == null) {
            iconWorker = new IconWorker(this.uploadPolicy, this.fileChooser, this, file);
            this.hashMap.put(file.getAbsolutePath(), iconWorker);
            this.execute(iconWorker);
            return emptyIcon;
        }
        return iconWorker.getIcon();
    }

    public String getName(File f) {
        return null;
    }

    public String getTypeDescription(File f) {
        return null;
    }

    public Boolean isTraversable(File f) {
        return null;
    }

    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(iconWorkerThreadGroup, runnable);
        thread.setPriority(1);
        return thread;
    }
}

