/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.gui.ColumnComparator;
import wjhk.jupload2.policies.UploadPolicy;

class FilePanelDataModel2
extends AbstractTableModel {
    private static final long serialVersionUID = 1473262424494858913L;
    public static final int COLINDEX_NAME = 0;
    public static final int COLINDEX_SIZE = 1;
    public static final int COLINDEX_DIRECTORY = 2;
    public static final int COLINDEX_MODIFIED = 3;
    public static final int COLINDEX_READABLE = 4;
    private UploadPolicy uploadPolicy = null;
    private String COL_NAME = null;
    private String COL_SIZE = null;
    private String COL_DIRECTORY = null;
    private String COL_MODIFIED = null;
    private String COL_READABLE = null;
    protected String[] columnNames = null;
    protected int[] columnSize = null;
    protected Class<?>[] columnClasses = null;
    private Vector<FileData> rows = new Vector();

    public FilePanelDataModel2(UploadPolicy uploadPolicy) {
        this.uploadPolicy = uploadPolicy;
        this.COL_NAME = uploadPolicy.getString("colName");
        this.COL_SIZE = uploadPolicy.getString("colSize");
        this.COL_DIRECTORY = uploadPolicy.getString("colDirectory");
        this.COL_MODIFIED = uploadPolicy.getString("colModified");
        this.COL_READABLE = uploadPolicy.getString("colReadable");
        this.columnNames = new String[]{this.COL_NAME, this.COL_SIZE, this.COL_DIRECTORY, this.COL_MODIFIED, this.COL_READABLE};
        this.columnSize = new int[]{150, 75, 199, 130, 75};
        this.columnClasses = new Class[]{String.class, Long.class, String.class, Date.class, Boolean.class};
    }

    public boolean contains(File file) {
        Iterator<FileData> i = this.rows.iterator();
        while (i.hasNext()) {
            if (!file.equals(i.next().getFile())) continue;
            return true;
        }
        return false;
    }

    public void addFile(File file, File root) {
        if (this.contains(file)) {
            this.uploadPolicy.displayWarn("File " + file.getName() + " already exists");
        } else if (!this.uploadPolicy.fileFilterAccept(file)) {
            String msg = file.getName() + " : " + this.uploadPolicy.getString("errForbiddenExtension");
            this.uploadPolicy.alertStr(msg);
            this.uploadPolicy.displayWarn(msg);
        } else {
            FileData df = this.uploadPolicy.createFileData(file, root);
            if (df != null) {
                this.rows.add(df);
                this.fireTableDataChanged();
            }
        }
    }

    public File getFileAt(int row) {
        return this.rows.get(row).getFile();
    }

    public FileData getFileDataAt(int row) {
        try {
            return this.rows.get(row);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public void removeRow(int row) {
        this.rows.remove(row);
        this.fireTableDataChanged();
    }

    public void removeRow(FileData fileData) {
        for (FileData item : this.rows) {
            if (!item.getFile().equals(fileData.getFile())) continue;
            this.rows.removeElement(item);
            this.fireTableDataChanged();
            break;
        }
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public boolean isCellEditable(int arg0, int arg1) {
        return false;
    }

    public void sortColumn(int col, boolean ascending) {
        Collections.sort(this.rows, new ColumnComparator(col, ascending));
        this.fireTableDataChanged();
    }

    public boolean isSortable(int col) {
        return Boolean.class != this.getColumnClass(col);
    }

    public Class getColumnClass(int arg0) {
        return this.columnClasses[arg0];
    }

    public Object getValueAt(int row, int col) {
        FileData fileData = this.getFileDataAt(row);
        if (null == fileData) {
            this.uploadPolicy.displayWarn("Row index out of bounds " + this.getClass().getName() + ": " + row);
            return null;
        }
        String colName = this.getColumnName(col);
        if (colName.equals(this.COL_NAME)) {
            return fileData.getFileName();
        }
        if (colName.equals(this.COL_SIZE)) {
            return new Long(fileData.getFileLength());
        }
        if (colName.equals(this.COL_DIRECTORY)) {
            return fileData.getDirectory();
        }
        if (colName.equals(this.COL_MODIFIED)) {
            return fileData.getLastModified();
        }
        if (colName.equals(this.COL_READABLE)) {
            return new Boolean(fileData.canRead());
        }
        this.uploadPolicy.displayErr("Unknown column in " + this.getClass().getName() + ": " + colName);
        return null;
    }

    public void setValueAt(Object arg0, int arg1, int arg2) {
        this.uploadPolicy.displayWarn(this.getClass().getName() + ".setValueAt: no action");
    }

    public String getColumnName(int arg0) {
        return this.columnNames[arg0];
    }

    public int getColumnSize(int col) {
        return this.columnSize[col];
    }
}

