/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.io.OutputStream;
import javax.swing.JProgressBar;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadExceptionUploadFailed;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.FileUploadThread;
import wjhk.jupload2.upload.UploadFileData;

public abstract class DefaultFileUploadThread
extends Thread
implements FileUploadThread {
    UploadFileData[] filesToUpload = null;
    UploadPolicy uploadPolicy = null;
    long maxChunkSize;
    int nbMaxFilesPerUpload;
    boolean stop = false;
    Exception uploadException = null;
    private JProgressBar progressBar = null;
    private long totalFilesLength = 0L;
    private long uploadedLength = 0L;
    private long startTime;
    private String responseMsg;

    public DefaultFileUploadThread(FileData[] filesDataParam, UploadPolicy uploadPolicy, JProgressBar progressBar) {
        this.uploadPolicy = uploadPolicy;
        this.progressBar = progressBar;
        int nbFilesToUpload = 0;
        for (int i = 0; i < filesDataParam.length; ++i) {
            if (!filesDataParam[i].canRead()) continue;
            ++nbFilesToUpload;
        }
        this.filesToUpload = new UploadFileData[nbFilesToUpload];
        int iFileIndex = 0;
        for (int i = 0; i < filesDataParam.length; ++i) {
            if (filesDataParam[i].canRead()) {
                this.filesToUpload[iFileIndex++] = new UploadFileData(filesDataParam[i], this, uploadPolicy);
                continue;
            }
            uploadPolicy.displayWarn(filesDataParam[i].getFileName() + " is read only: it won't be uploaded.");
        }
    }

    public long getUploadedLength() {
        return this.uploadedLength;
    }

    public long getTotalLength() {
        return this.totalFilesLength;
    }

    public void stopUpload() {
        this.stop = true;
    }

    public boolean isUploadStopped() {
        return this.stop;
    }

    public String getResponseMsg() {
        return this.responseMsg;
    }

    public Exception getException() {
        return this.uploadException;
    }

    public void nbBytesUploaded(long nbBytes) {
        this.uploadedLength += nbBytes;
    }

    private final void beforeUpload() throws JUploadException {
        for (int i = 0; i < this.filesToUpload.length && !this.stop; ++i) {
            if (null != this.progressBar) {
                this.progressBar.setValue(i);
                this.progressBar.setString(String.format(this.uploadPolicy.getString("preparingFile"), new Integer(i + 1), new Integer(this.filesToUpload.length)));
            }
            this.filesToUpload[i].beforeUpload();
            this.totalFilesLength += this.filesToUpload[i].getRemainingLength();
        }
        if (null != this.progressBar) {
            this.progressBar.setValue(0);
            this.progressBar.setMaximum(100);
            this.progressBar.setString("");
        }
    }

    abstract long getAdditionnalBytesForUpload(int var1);

    abstract void beforeRequest(int var1, int var2) throws JUploadException;

    abstract void startRequest(long var1, boolean var3, int var4, boolean var5) throws JUploadException;

    abstract int finishRequest() throws JUploadException;

    abstract void beforeFile(int var1) throws JUploadException;

    abstract void afterFile(int var1) throws JUploadException;

    abstract void cleanRequest() throws JUploadException;

    abstract void cleanAll() throws JUploadException;

    abstract OutputStream getOutputStream() throws JUploadException;

    abstract String getResponseBody();

    void setResponseMsg(String msg) {
        this.responseMsg = msg;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void run() {
        boolean bUploadOk;
        block21: {
            block20: {
                bUploadOk = true;
                this.maxChunkSize = this.uploadPolicy.getMaxChunkSize();
                this.nbMaxFilesPerUpload = this.uploadPolicy.getNbFilesPerRequest();
                this.startTime = 0L;
                this.uploadedLength = 0L;
                this.totalFilesLength = 0L;
                if (null != this.progressBar) {
                    this.progressBar.setValue(0);
                    this.progressBar.setMaximum(this.filesToUpload.length);
                }
                this.beforeUpload();
                this.startTime = System.currentTimeMillis();
                this.beforeRequest(0, this.filesToUpload.length);
                int iFirstFileForThisUpload = 0;
                int iNbFilesForThisUpload = 0;
                int currentFile = 0;
                long nextUploadContentLength = 0L;
                long currentUploadContentLength = 0L;
                while (iFirstFileForThisUpload + iNbFilesForThisUpload < this.filesToUpload.length && bUploadOk && !this.stop) {
                    currentFile = iFirstFileForThisUpload + iNbFilesForThisUpload;
                    nextUploadContentLength = this.filesToUpload[currentFile].getRemainingLength() + this.getAdditionnalBytesForUpload(currentFile);
                    if (iNbFilesForThisUpload > 0 && currentUploadContentLength + nextUploadContentLength > this.maxChunkSize && !this.stop) {
                        bUploadOk = this.doUpload(iFirstFileForThisUpload, iNbFilesForThisUpload);
                        iFirstFileForThisUpload += iNbFilesForThisUpload;
                        iNbFilesForThisUpload = 0;
                        currentUploadContentLength = 0L;
                    }
                    ++iNbFilesForThisUpload;
                    if ((currentUploadContentLength += nextUploadContentLength) > this.maxChunkSize && !this.stop) {
                        bUploadOk = this.doUpload(iFirstFileForThisUpload, iNbFilesForThisUpload);
                        iFirstFileForThisUpload += iNbFilesForThisUpload;
                        iNbFilesForThisUpload = 0;
                        currentUploadContentLength = 0L;
                    }
                    if (iNbFilesForThisUpload != this.nbMaxFilesPerUpload || this.stop) continue;
                    bUploadOk = this.doUpload(iFirstFileForThisUpload, iNbFilesForThisUpload);
                    iFirstFileForThisUpload += iNbFilesForThisUpload;
                    iNbFilesForThisUpload = 0;
                    currentUploadContentLength = 0L;
                }
                if (iNbFilesForThisUpload > 0 && bUploadOk && !this.stop) {
                    bUploadOk = this.doUpload(iFirstFileForThisUpload, iNbFilesForThisUpload);
                }
                if (null == this.progressBar) break block20;
                if (bUploadOk || this.stop) {
                    if (!this.stop) {
                        this.progressBar.setString(String.format(this.uploadPolicy.getString("nbUploadedFiles"), new Integer(iFirstFileForThisUpload + iNbFilesForThisUpload)));
                    } else {
                        this.progressBar.setString(String.format(this.uploadPolicy.getString("infoAborted"), new Integer(iFirstFileForThisUpload - 1)));
                    }
                    break block20;
                }
                this.progressBar.setString(this.uploadPolicy.getString("errDuringUpload"));
            }
            Object var10_8 = null;
            this.uploadPolicy.displayDebug("FileUploadThread: within run().finally", 70);
            try {
                for (int i = 0; i < this.filesToUpload.length; ++i) {
                    UploadFileData f = this.filesToUpload[i];
                    if (f == null) continue;
                    f.afterUpload();
                }
            }
            catch (Exception e2) {
                this.uploadPolicy.displayWarn(e2.getClass().getName() + " in " + this.getClass().getName() + ".run() (finally)");
                {
                    break block21;
                }
            }
            break block21;
            {
                catch (JUploadException e) {
                    bUploadOk = false;
                    this.uploadException = e;
                    this.uploadPolicy.displayErr(e);
                    this.progressBar.setString(e.getMessage());
                    Object var10_9 = null;
                    this.uploadPolicy.displayDebug("FileUploadThread: within run().finally", 70);
                    try {
                        for (int i = 0; i < this.filesToUpload.length; ++i) {
                            UploadFileData f = this.filesToUpload[i];
                            if (f == null) continue;
                            f.afterUpload();
                        }
                        break block21;
                    }
                    catch (Exception e2) {
                        this.uploadPolicy.displayWarn(e2.getClass().getName() + " in " + this.getClass().getName() + ".run() (finally)");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this.uploadPolicy.displayDebug("FileUploadThread: within run().finally", 70);
                try {
                    for (int i = 0; i < this.filesToUpload.length; ++i) {
                        UploadFileData f = this.filesToUpload[i];
                        if (f == null) continue;
                        f.afterUpload();
                    }
                }
                catch (Exception e2) {
                    this.uploadPolicy.displayWarn(e2.getClass().getName() + " in " + this.getClass().getName() + ".run() (finally)");
                }
                throw throwable;
            }
        }
        if (!bUploadOk && !this.stop) {
            this.uploadPolicy.sendDebugInformation("Error in Upload");
        }
    }

    private final boolean doUpload(int firstFileToUploadParam, int nbFilesToUploadParam) {
        int i;
        boolean bReturn = true;
        boolean bLastChunk = false;
        boolean bChunkEnabled = false;
        int chunkPart = 0;
        int nbFilesToUpload = 0;
        long totalContentLength = 0L;
        long totalFileLength = 0L;
        long contentLength = 0L;
        long thisChunkSize = 0L;
        int firstFileToUpload = 0;
        String msg = nbFilesToUploadParam == 1 ? firstFileToUploadParam + 1 + "/" + this.filesToUpload.length : firstFileToUploadParam + 1 + "-" + (firstFileToUploadParam + nbFilesToUploadParam) + "/" + this.filesToUpload.length;
        if (!this.stop && null != this.progressBar) {
            this.progressBar.setString(String.format(this.uploadPolicy.getString("infoUploading"), msg));
        }
        try {
            this.beforeRequest(firstFileToUploadParam, nbFilesToUploadParam);
            for (i = 0; i < nbFilesToUploadParam && !this.stop; ++i) {
                totalContentLength += this.filesToUpload[firstFileToUploadParam + i].getUploadLength();
                totalContentLength += this.getAdditionnalBytesForUpload(firstFileToUploadParam + i);
                totalFileLength += this.filesToUpload[firstFileToUploadParam + i].getUploadLength();
                if (this.uploadPolicy.getDebugLevel() < 80) continue;
                this.uploadPolicy.displayDebug("file " + (firstFileToUploadParam + i) + ": content=" + this.filesToUpload[firstFileToUploadParam + i].getUploadLength() + " bytes, getAdditionnalBytesForUpload=" + this.getAdditionnalBytesForUpload(firstFileToUploadParam + i) + " bytes", 80);
            }
        }
        catch (JUploadException e) {
            this.uploadPolicy.displayErr(e);
            this.uploadException = e;
        }
        if (totalFileLength >= this.maxChunkSize) {
            if (nbFilesToUploadParam > 1) {
                this.uploadException = new JUploadException("totalContentLength >= chunkSize: nbFilesToUploadParam should be more than 1 (doUpload)");
            }
            bChunkEnabled = true;
        }
        while (!bLastChunk && this.uploadException == null && !this.stop) {
            try {
                if (bChunkEnabled) {
                    firstFileToUpload = firstFileToUploadParam;
                    nbFilesToUpload = 1;
                    ++chunkPart;
                    bLastChunk = contentLength > this.filesToUpload[firstFileToUploadParam].getRemainingLength();
                    thisChunkSize = bLastChunk ? this.filesToUpload[firstFileToUploadParam].getRemainingLength() : this.maxChunkSize;
                    contentLength = thisChunkSize + this.getAdditionnalBytesForUpload(firstFileToUploadParam);
                } else {
                    bLastChunk = true;
                    contentLength = totalContentLength;
                    firstFileToUpload = firstFileToUploadParam;
                    nbFilesToUpload = nbFilesToUploadParam;
                }
                this.startRequest(contentLength, bChunkEnabled, chunkPart, bLastChunk);
                for (i = 0; i < nbFilesToUpload && !this.stop; ++i) {
                    this.beforeFile(firstFileToUpload + i);
                    if (!bChunkEnabled) {
                        thisChunkSize = this.filesToUpload[firstFileToUpload + i].getUploadLength();
                    }
                    this.filesToUpload[firstFileToUpload + i].uploadFile(this.getOutputStream(), thisChunkSize);
                    if (!bChunkEnabled || bLastChunk) {
                        if (!this.stop && null != this.progressBar) {
                            this.progressBar.setString(String.format(this.uploadPolicy.getString("infoUploaded"), msg));
                        }
                        if (this.filesToUpload[firstFileToUpload + i].getRemainingLength() > 0L) {
                            this.uploadException = new JUploadExceptionUploadFailed("Files has not be entirely uploaded. The remaining size is " + this.filesToUpload[firstFileToUpload + i].getRemainingLength() + " bytes. File size was: " + this.filesToUpload[firstFileToUpload + i].getUploadLength() + " bytes.");
                        }
                    }
                    this.afterFile(firstFileToUpload + i);
                }
                this.getOutputStream().flush();
                int status = this.finishRequest();
                if (!this.stop) {
                    this.uploadPolicy.checkUploadSuccess(status, this.getResponseMsg(), this.getResponseBody());
                }
            }
            catch (Exception e) {
                this.uploadException = e;
                bReturn = false;
            }
            if (this.uploadPolicy.getDebugLevel() <= 80) continue;
            this.uploadPolicy.displayDebug("-------- Response Body Start --------", 80);
            this.uploadPolicy.displayDebug(this.getResponseBody(), 80);
            this.uploadPolicy.displayDebug("--------- Response Body End ---------", 80);
        }
        try {
            this.cleanRequest();
        }
        catch (JUploadException e) {
            this.uploadException = e;
            bReturn = false;
        }
        if (this.uploadException == null) {
            for (int i2 = 0; i2 < nbFilesToUpload && !this.stop; ++i2) {
                this.uploadPolicy.getApplet().getUploadPanel().getFilePanel().remove(this.filesToUpload[firstFileToUpload + i2]);
            }
        } else {
            this.uploadPolicy.displayErr(this.uploadException);
        }
        return bReturn;
    }

    public void close() {
        try {
            this.cleanAll();
        }
        catch (JUploadException e) {
            this.uploadPolicy.displayErr(e);
        }
    }
}

