/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.policies;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import wjhk.jupload2.JUploadApplet;
import wjhk.jupload2.policies.UploadPolicy;

public class UploadPolicyFactory {
    public static UploadPolicy getUploadPolicy(JUploadApplet theApplet) throws Exception {
        UploadPolicy uploadPolicy = theApplet.getUploadPolicy();
        if (uploadPolicy == null) {
            String uploadPolicyStr = UploadPolicyFactory.getParameter(theApplet, "uploadPolicy", "DefaultUploadPolicy", null);
            String action = null;
            boolean usingDefaultUploadPolicy = false;
            try {
                action = uploadPolicyStr;
                Class<?> uploadPolicyClass = null;
                if (!uploadPolicyStr.contains(".")) {
                    try {
                        uploadPolicyClass = Class.forName("wjhk.jupload2.policies." + uploadPolicyStr);
                    }
                    catch (ClassNotFoundException e1) {
                        uploadPolicyClass = null;
                    }
                }
                if (null == uploadPolicyClass) {
                    try {
                        uploadPolicyClass = Class.forName(uploadPolicyStr);
                    }
                    catch (ClassNotFoundException e2) {
                        usingDefaultUploadPolicy = true;
                        uploadPolicyClass = Class.forName("wjhk.jupload2.policies.DefaultUploadPolicy");
                    }
                }
                action = "constructorParameters";
                Class[] constructorParameters = new Class[]{Class.forName("wjhk.jupload2.JUploadApplet")};
                Constructor<?> constructor = uploadPolicyClass.getConstructor(constructorParameters);
                Object[] params = new Object[]{theApplet};
                action = "newInstance";
                uploadPolicy = (UploadPolicy)constructor.newInstance(params);
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException) {
                    Throwable t = ((InvocationTargetException)e).getTargetException();
                    System.out.println("-ERROR- " + t.getMessage());
                    t.printStackTrace();
                }
                System.out.println("-ERROR- " + e.getClass().getName() + " in " + action + "(error message: " + e.getMessage() + ")");
                throw e;
            }
            uploadPolicy.displayDebug("uploadPolicy parameter = " + uploadPolicyStr, 1);
            if (usingDefaultUploadPolicy) {
                uploadPolicy.displayWarn("Unable to create the '" + uploadPolicyStr + "'. Using the DefaultUploadPolicy instead.");
            } else {
                uploadPolicy.displayDebug("uploadPolicy = " + uploadPolicy.getClass().getName(), 20);
            }
            uploadPolicy.displayParameterStatus();
        }
        return uploadPolicy;
    }

    public static String getParameter(JUploadApplet theApplet, String key, String def, UploadPolicy uploadPolicy) {
        if (theApplet == null) {
            return System.getProperty(key) != null ? System.getProperty(key) : def;
        }
        return theApplet.getParameter(key) != null ? theApplet.getParameter(key) : def;
    }

    public static int getParameter(JUploadApplet theApplet, String key, int def, UploadPolicy uploadPolicy) {
        String paramDef = Integer.toString(def);
        String paramStr = theApplet == null ? (System.getProperty(key) != null ? System.getProperty(key) : paramDef) : (theApplet.getParameter(key) != null ? theApplet.getParameter(key) : paramDef);
        return UploadPolicyFactory.parseInt(paramStr, def, uploadPolicy);
    }

    public static float getParameter(JUploadApplet theApplet, String key, float def, UploadPolicy uploadPolicy) {
        String paramDef = Float.toString(def);
        String paramStr = theApplet == null ? (System.getProperty(key) != null ? System.getProperty(key) : paramDef) : (theApplet.getParameter(key) != null ? theApplet.getParameter(key) : paramDef);
        return UploadPolicyFactory.parseFloat(paramStr, def, uploadPolicy);
    }

    public static long getParameter(JUploadApplet theApplet, String key, long def, UploadPolicy uploadPolicy) {
        String paramDef = Long.toString(def);
        String paramStr = theApplet == null ? (System.getProperty(key) != null ? System.getProperty(key) : paramDef) : (theApplet.getParameter(key) != null ? theApplet.getParameter(key) : paramDef);
        return UploadPolicyFactory.parseLong(paramStr, def, uploadPolicy);
    }

    public static boolean getParameter(JUploadApplet theApplet, String key, boolean def, UploadPolicy uploadPolicy) {
        String paramDef;
        String string = paramDef = def ? "true" : "false";
        String paramStr = theApplet == null ? (System.getProperty(key) != null ? System.getProperty(key) : paramDef) : (theApplet.getParameter(key) != null ? theApplet.getParameter(key) : paramDef);
        return UploadPolicyFactory.parseBoolean(paramStr, def, uploadPolicy);
    }

    public static int parseInt(String value, int def, UploadPolicy uploadPolicy) {
        int ret;
        block2: {
            ret = def;
            try {
                ret = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                ret = def;
                if (uploadPolicy == null) break block2;
                uploadPolicy.displayWarn("Invalid int value: " + value + ", using default value: " + def);
            }
        }
        return ret;
    }

    public static float parseFloat(String value, float def, UploadPolicy uploadPolicy) {
        float ret;
        block2: {
            ret = def;
            try {
                ret = Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                ret = def;
                if (uploadPolicy == null) break block2;
                uploadPolicy.displayWarn("Invalid float value: " + value + ", using default value: " + def);
            }
        }
        return ret;
    }

    public static long parseLong(String value, long def, UploadPolicy uploadPolicy) {
        long ret;
        block2: {
            ret = def;
            try {
                ret = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                ret = def;
                if (uploadPolicy == null) break block2;
                uploadPolicy.displayWarn("Invalid long value: " + value + ", using default value: " + def);
            }
        }
        return ret;
    }

    public static boolean parseBoolean(String value, boolean def, UploadPolicy uploadPolicy) {
        if (value.toUpperCase().equals("FALSE")) {
            return false;
        }
        if (value.toUpperCase().equals("TRUE")) {
            return true;
        }
        if (uploadPolicy != null) {
            uploadPolicy.displayWarn("Invalid boolean value: " + value + ", using default value: " + def);
        }
        return def;
    }
}

