/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.policies;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.dnd.DropTargetDropEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.text.BadLocationException;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import wjhk.jupload2.JUploadApplet;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadExceptionUploadFailed;
import wjhk.jupload2.filedata.DefaultFileData;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.gui.JUploadFileChooser;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.gui.JUploadTextArea;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.policies.UploadPolicyFactory;
import wjhk.jupload2.upload.HttpConnect;

public class DefaultUploadPolicy
implements UploadPolicy {
    private JUploadApplet applet = null;
    private String afterUploadURL = UploadPolicy.DEFAULT_AFTER_UPLOAD_URL;
    private boolean allowHttpPersistent = true;
    private String allowedFileExtensions = "";
    private boolean showLogWindow = true;
    private boolean showStatusbar = true;
    private String specificHeaders = null;
    private int debugLevel = 0;
    private int fileChooserIconFromFileContent = 0;
    private int fileChooserIconSize = 20;
    private String filenameEncoding = UploadPolicy.DEFAULT_FILENAME_ENCODING;
    private String lang = UploadPolicy.DEFAULT_LANG;
    private String lookAndFeel = "";
    private int nbFilesPerRequest = -1;
    private long maxChunkSize = Long.MAX_VALUE;
    private long maxFileSize = Long.MAX_VALUE;
    private String postURL = UploadPolicy.DEFAULT_POST_URL;
    private String serverProtocol = UploadPolicy.DEFAULT_SERVER_PROTOCOL;
    private String stringUploadError = "^ERROR: (.*)$";
    private String stringUploadSuccess = "^SUCCESS$";
    private String urlToSendErrorTo = UploadPolicy.DEFAULT_URL_TO_SEND_ERROR_TO;
    private String formData = UploadPolicy.DEFAULT_FORMDATA;
    private String afterUploadTarget = UploadPolicy.DEFAULT_AFTER_UPLOAD_TARGET;
    private String lastResponseBody = null;
    private String lastResponseMessage = null;
    private int sslVerifyCert = 0;
    private static final String CRLF = System.getProperty("line.separator");
    private Vector<String> headers = new Vector();
    private JUploadTextArea logWindow = null;
    private ResourceBundle resourceBundle = null;
    private PrintStream debugOut = null;
    private File debugFile = null;
    private boolean debugOk = true;
    private String cookie = null;
    private String userAgent = null;
    private static final int MAX_DEBUG_LINES = 10000;
    protected Pattern patternSuccess = Pattern.compile("^SUCCESS$");
    protected Pattern patternError = Pattern.compile("^ERROR: (.*)$");

    public DefaultUploadPolicy(JUploadApplet theApplet) throws JUploadException {
        this.applet = theApplet;
        this.logWindow = theApplet.getLogWindow();
        this.setLang(UploadPolicyFactory.getParameter(theApplet, "lang", DEFAULT_LANG, (UploadPolicy)this));
        this.setLookAndFeel(UploadPolicyFactory.getParameter(theApplet, "lookAndFeel", "", (UploadPolicy)this));
        this.setSslVerifyCert(UploadPolicyFactory.getParameter(theApplet, "sslVerifyCert", "none", (UploadPolicy)this));
        this.setAfterUploadURL(UploadPolicyFactory.getParameter(theApplet, "afterUploadURL", DEFAULT_AFTER_UPLOAD_URL, (UploadPolicy)this));
        this.setAllowedFileExtensions(UploadPolicyFactory.getParameter(theApplet, "allowedFileExtensions", "", (UploadPolicy)this));
        this.setAllowHttpPersistent(UploadPolicyFactory.getParameter(theApplet, "allowHttpPersistent", true, (UploadPolicy)this));
        this.setShowStatusbar(UploadPolicyFactory.getParameter(theApplet, "showStatusbar", true, (UploadPolicy)this));
        this.setShowLogWindow(UploadPolicyFactory.getParameter(theApplet, "showLogWindow", true, (UploadPolicy)this));
        this.setDebugLevel(UploadPolicyFactory.getParameter(theApplet, "debugLevel", 0, (UploadPolicy)this), false);
        this.setFileChooserIconFromFileContent(UploadPolicyFactory.getParameter(theApplet, "fileChooserIconFromFileContent", 0, (UploadPolicy)this));
        this.setFileChooserIconSize(UploadPolicyFactory.getParameter(theApplet, "fileChooserIconSize", 20, (UploadPolicy)this));
        this.setFilenameEncoding(UploadPolicyFactory.getParameter(theApplet, "filenameEncoding", DEFAULT_FILENAME_ENCODING, (UploadPolicy)this));
        this.setNbFilesPerRequest(UploadPolicyFactory.getParameter(theApplet, "nbFilesPerRequest", -1, (UploadPolicy)this));
        this.setMaxChunkSize(UploadPolicyFactory.getParameter(theApplet, "maxChunkSize", Long.MAX_VALUE, (UploadPolicy)this));
        this.setMaxFileSize(UploadPolicyFactory.getParameter(theApplet, "maxFileSize", Long.MAX_VALUE, (UploadPolicy)this));
        this.setPostURL(UploadPolicyFactory.getParameter(theApplet, "postURL", DEFAULT_POST_URL, (UploadPolicy)this));
        this.setSpecificHeaders(UploadPolicyFactory.getParameter(theApplet, "specificHeaders", DEFAULT_SPECIFIC_HEADERS, (UploadPolicy)this));
        this.setServerProtocol(UploadPolicyFactory.getParameter(theApplet, "serverProtocol", DEFAULT_SERVER_PROTOCOL, (UploadPolicy)this));
        this.setStringUploadError(UploadPolicyFactory.getParameter(theApplet, "stringUploadError", "^ERROR: (.*)$", (UploadPolicy)this));
        this.setStringUploadSuccess(UploadPolicyFactory.getParameter(theApplet, "stringUploadSuccess", "^SUCCESS$", (UploadPolicy)this));
        this.setUrlToSendErrorTo(UploadPolicyFactory.getParameter(theApplet, "urlToSendErrorTo", DEFAULT_URL_TO_SEND_ERROR_TO, (UploadPolicy)this));
        this.formData = UploadPolicyFactory.getParameter(theApplet, "formdata", DEFAULT_FORMDATA, (UploadPolicy)this);
        this.afterUploadTarget = UploadPolicyFactory.getParameter(theApplet, "afterUploadTarget", DEFAULT_AFTER_UPLOAD_TARGET, (UploadPolicy)this);
        try {
            JSObject awin = JSObject.getWindow((Applet)this.getApplet());
            JSObject doc = (JSObject)awin.getMember("document");
            this.cookie = (String)doc.getMember("cookie");
            JSObject nav = (JSObject)awin.getMember("navigator");
            this.userAgent = (String)nav.getMember("userAgent");
            this.displayDebug("cookie: " + this.cookie, 10);
            this.displayDebug("userAgent: " + this.userAgent, 10);
        }
        catch (JSException e) {
            this.displayWarn("JSException (" + e.getClass() + ": " + e.getMessage() + ") in DefaultUploadPolicy, trying default values.");
            this.cookie = System.getProperty("debug_cookie");
            this.userAgent = System.getProperty("debug_agent");
        }
        if (this.cookie != null) {
            this.addHeader("Cookie: " + this.cookie);
        }
        if (this.userAgent != null) {
            this.addHeader("User-Agent: " + this.userAgent);
        }
    }

    public void addHeader(String header) {
        this.headers.add(header);
    }

    public void beforeUpload() {
    }

    public boolean checkUploadSuccess(int status, String msg, String body) throws JUploadException {
        this.lastResponseBody = body;
        this.lastResponseMessage = msg;
        this.displayDebug("HTTP status: " + msg, 40);
        if (status != 200 && status != 100) {
            throw new JUploadExceptionUploadFailed("Received HTTP status " + msg);
        }
        StringTokenizer st = new StringTokenizer(body, "\n\r");
        while (st.hasMoreTokens()) {
            Matcher matcherError;
            String line = st.nextToken();
            if (!this.stringUploadSuccess.equals("") && this.patternSuccess.matcher(line).matches()) {
                return true;
            }
            if (this.stringUploadError.equals("") || !(matcherError = this.patternError.matcher(line)).matches()) continue;
            String errmsg = "An error occurs during upload (but the applet couldn't find the error message)";
            if (matcherError.groupCount() > 0 && (errmsg = matcherError.group(1)).equals("")) {
                errmsg = "An unknown error occurs during upload.";
            }
            this.lastResponseMessage = errmsg;
            throw new JUploadExceptionUploadFailed(errmsg);
        }
        if (this.stringUploadSuccess.equals("")) {
            return true;
        }
        throw new JUploadExceptionUploadFailed(this.getClass().getName() + ".checkUploadSuccess(): The string \"" + this.stringUploadSuccess + "\" was not found in the response body");
    }

    private String jsString(String s) {
        return "'" + s.replaceAll("'", "\\'") + "'";
    }

    public void afterUpload(Exception e, String serverOutput) throws JUploadException {
        String url = this.getAfterUploadURL();
        if (url != null) {
            try {
                if (url.toLowerCase().startsWith("javascript:")) {
                    String expr = url.substring(11);
                    if (expr.contains("%msg%")) {
                        expr = expr.replaceAll("%msg%", this.jsString(this.getLastResponseMessage()));
                    }
                    if (expr.contains("%body%")) {
                        expr = expr.replaceAll("%body%", this.jsString(this.getLastResponseBody()));
                    }
                    if (expr.contains("%success%")) {
                        expr = expr.replaceAll("%success%", null == e ? "true" : "false");
                    }
                    JSObject.getWindow((Applet)this.getApplet()).eval(expr);
                } else if (null == e) {
                    String target = this.getAfterUploadTarget();
                    if (this.getDebugLevel() >= 100) {
                        this.alertStr("No switch to getAfterUploadURL, because debug level is " + this.getDebugLevel() + " (>=100)");
                    } else {
                        this.getApplet().getAppletContext().showDocument(new URL(url), null == target ? "_self" : target);
                    }
                }
            }
            catch (Exception ee) {
                this.displayErr(ee);
            }
        }
    }

    public void alertStr(String str) {
        JOptionPane.showMessageDialog(null, str, "Alert", 2);
    }

    public void alert(String key) {
        this.alertStr(this.getString(key));
    }

    public FileData createFileData(File file, File root) {
        return new DefaultFileData(file, root, this);
    }

    public JPanel createTopPanel(JButton browse, JButton remove, JButton removeAll, JUploadPanel jUploadPanel) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3, 10, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        jPanel.add(browse);
        jPanel.add(removeAll);
        jPanel.add(remove);
        jUploadPanel.setBorder(BorderFactory.createLineBorder(SystemColor.controlDkShadow));
        return jPanel;
    }

    public JPanel createProgressPanel(JProgressBar progressBar, JButton uploadButton, JButton stopButton, JPanel mainPanel) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(10, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        jPanel.add((Component)uploadButton, "Before");
        jPanel.add((Component)progressBar, "Center");
        jPanel.add((Component)stopButton, "After");
        return jPanel;
    }

    public JPanel createStatusBar(JLabel content, JPanel mainPanel) {
        if (this.showStatusbar) {
            JPanel pstatus = new JPanel();
            pstatus.setLayout(new BorderLayout());
            pstatus.add((Component)content, "Center");
            pstatus.setBorder(new BevelBorder(1));
            return pstatus;
        }
        return null;
    }

    public void addComponentsToJUploadPanel(JUploadPanel jUploadPanel) {
        jUploadPanel.setLayout(new BoxLayout(jUploadPanel, 1));
        JPanel topPanel = this.createTopPanel(jUploadPanel.getBrowseButton(), jUploadPanel.getRemoveButton(), jUploadPanel.getRemoveAllButton(), jUploadPanel);
        if (topPanel != null) {
            jUploadPanel.add(topPanel);
            topPanel.addMouseListener(jUploadPanel);
        }
        jUploadPanel.add(jUploadPanel.getFilePanel().getDropComponent());
        JPanel progressPanel = this.createProgressPanel(jUploadPanel.getProgressBar(), jUploadPanel.getUploadButton(), jUploadPanel.getStopButton(), jUploadPanel);
        jUploadPanel.add(progressPanel);
        jUploadPanel.addMouseListener(jUploadPanel);
        jUploadPanel.showOrHideLogWindow();
        jUploadPanel.add(jUploadPanel.getJLogWindowPane());
        JPanel p = this.createStatusBar(jUploadPanel.getStatusLabel(), jUploadPanel);
        if (null != p) {
            jUploadPanel.add(p);
            p.addMouseListener(jUploadPanel);
        }
    }

    public void displayErr(Exception e) {
        this.displayErr(e.getMessage(), e);
    }

    public void displayErr(String err) {
        this.displayErr(err, null);
    }

    public void displayErr(String errorText, Exception exception) {
        if (this.getDebugLevel() == 0) {
            this.setDebugLevel(1);
        }
        String exceptionMsg = null;
        String alertMsg = errorText;
        String logMsg = errorText;
        Exception justToPrintAStackTrace = exception;
        if (exception == null) {
            justToPrintAStackTrace = new Exception();
        } else {
            exceptionMsg = exception.getClass().getName() + ": " + exception.getMessage();
            if (errorText == null || errorText.equals("")) {
                alertMsg = "Unknown error (" + exceptionMsg + ")";
            }
            logMsg = exceptionMsg + " (" + errorText + ")";
        }
        this.alertStr(alertMsg);
        this.displayMsg("[ERROR] ", logMsg);
        if (exception != null) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bs);
            justToPrintAStackTrace.printStackTrace(ps);
            ps.close();
            this.displayMsg("", bs.toString());
        }
    }

    public void displayInfo(String info) {
        this.displayMsg("[INFO] ", info);
    }

    public void displayWarn(String warn) {
        this.displayMsg("[WARN] ", warn);
    }

    public void displayDebug(String debug, int minDebugLevel) {
        String tag = "[DEBUG] ";
        if (this.debugLevel >= minDebugLevel) {
            this.displayMsg("[DEBUG] ", debug);
        } else {
            this.addMsgToDebugLog(this.timestamp("[DEBUG] ", debug));
        }
    }

    public String getString(String key) {
        String ret = this.resourceBundle.getString(key);
        return ret;
    }

    public String getUploadFilename(FileData fileData, int index) throws JUploadException {
        if (this.filenameEncoding == null || this.filenameEncoding.equals("")) {
            return fileData.getFileName();
        }
        try {
            return URLEncoder.encode(fileData.getFileName(), this.filenameEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new JUploadException(e);
        }
    }

    public String getUploadName(FileData fileData, int index) {
        return "File" + index;
    }

    public boolean isUploadReady() {
        return true;
    }

    public StringBuffer onAppendHeader(StringBuffer sb) {
        for (String header : this.headers) {
            this.displayDebug(header, 90);
            sb.append(header);
            sb.append("\r\n");
        }
        return sb;
    }

    public void onFileSelected(FileData fileData) {
    }

    public void onFileDoubleClicked(FileData fileData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void sendDebugInformation(String description) {
        block26: {
            if (null != this.urlToSendErrorTo && JOptionPane.showConfirmDialog(null, this.getString("questionSendMailOnError"), this.getString("Confirm"), 0, 3) == 0) {
                String line;
                this.displayDebug("Within response == true", 60);
                String query = null;
                String action = null;
                Socket sock = null;
                FilterOutputStream dataout = null;
                BufferedReader datain = null;
                StringBuffer sbHttpResponseBody = null;
                StringBuffer request = null;
                boolean localDebugOk = this.debugOk;
                this.debugOk = false;
                this.debugOut.flush();
                BufferedReader debugIn = new BufferedReader(new FileReader(this.debugFile));
                int contentLength = 0;
                while ((line = debugIn.readLine()) != null) {
                    contentLength += URLEncoder.encode(line + "\n", "UTF-8").length();
                }
                debugIn.close();
                debugIn = new BufferedReader(new FileReader(this.debugFile));
                query = "description=" + URLEncoder.encode(description, "UTF-8") + "&log=" + URLEncoder.encode("\n\nAn error occured during upload, in JUpload\nAll debug information is available below\n\n\n\n", "UTF-8");
                request = new StringBuffer();
                URL url = new URL(this.urlToSendErrorTo);
                request.append("POST ").append(url).append(" ").append(this.getServerProtocol()).append("\r\n").append("Host: ").append(url.getHost()).append("\r\n").append("Accept: */*\r\n").append("Content-type: application/x-www-form-urlencoded\r\n").append("Connection: close\r\n").append("Content-length: ").append(contentLength += query.length()).append("\r\n");
                this.onAppendHeader(request);
                request.append("\r\n").append(query);
                sock = new HttpConnect(this).Connect(url);
                dataout = new DataOutputStream(new BufferedOutputStream(sock.getOutputStream()));
                datain = new BufferedReader(new InputStreamReader(sock.getInputStream()));
                action = "send bytes (1)";
                ((DataOutputStream)dataout).writeBytes(request.toString());
                ((DataOutputStream)dataout).writeBytes(query);
                while ((line = debugIn.readLine()) != null) {
                    ((DataOutputStream)dataout).writeBytes(URLEncoder.encode(line + "\n", "UTF-8"));
                }
                debugIn.close();
                this.debugOk = localDebugOk;
                action = "flush";
                ((DataOutputStream)dataout).flush();
                action = "wait for server answer";
                String strUploadSuccess = this.getStringUploadSuccess();
                boolean uploadSuccess = false;
                boolean readingHttpBody = false;
                sbHttpResponseBody = new StringBuffer();
                while ((line = datain.readLine()) != null) {
                    action = "test success";
                    if (line.matches(strUploadSuccess)) {
                        uploadSuccess = true;
                    }
                    if (readingHttpBody) {
                        action = "sbHttpResponseBody";
                        sbHttpResponseBody.append(line).append("\n");
                    }
                    if (line.length() != 0) continue;
                    action = "readingHttpBody";
                    readingHttpBody = true;
                }
                if (!uploadSuccess) {
                    throw new JUploadExceptionUploadFailed(this.getString("errHttpResponse"));
                }
                Object var18_18 = null;
                this.debugOk = localDebugOk;
                try {
                    dataout.close();
                }
                catch (Exception e2) {
                    this.displayErr(this.getString("errDuringLogManagement") + " (dataout.close)", e2);
                }
                dataout = null;
                try {
                    datain.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                datain = null;
                try {
                    sock.close();
                }
                catch (Exception e2) {
                    this.displayErr(this.getString("errDuringLogManagement") + " (sock.close)", e2);
                }
                sock = null;
                this.displayDebug("Sent to server: " + request.toString(), 100);
                this.displayDebug("Body received: " + sbHttpResponseBody.toString(), 100);
                {
                    break block26;
                    catch (Exception e) {
                        this.debugOk = localDebugOk;
                        this.displayErr(this.getString("errDuringLogManagement") + " (" + action + ")", e);
                        Object var18_19 = null;
                        this.debugOk = localDebugOk;
                        try {
                            dataout.close();
                        }
                        catch (Exception e2) {
                            this.displayErr(this.getString("errDuringLogManagement") + " (dataout.close)", e2);
                        }
                        dataout = null;
                        try {
                            datain.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        datain = null;
                        try {
                            sock.close();
                        }
                        catch (Exception e2) {
                            this.displayErr(this.getString("errDuringLogManagement") + " (sock.close)", e2);
                        }
                        sock = null;
                        this.displayDebug("Sent to server: " + request.toString(), 100);
                        this.displayDebug("Body received: " + sbHttpResponseBody.toString(), 100);
                    }
                }
                catch (Throwable throwable) {
                    Object var18_20 = null;
                    this.debugOk = localDebugOk;
                    try {
                        dataout.close();
                    }
                    catch (Exception e2) {
                        this.displayErr(this.getString("errDuringLogManagement") + " (dataout.close)", e2);
                    }
                    dataout = null;
                    try {
                        datain.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    datain = null;
                    try {
                        sock.close();
                    }
                    catch (Exception e2) {
                        this.displayErr(this.getString("errDuringLogManagement") + " (sock.close)", e2);
                    }
                    sock = null;
                    this.displayDebug("Sent to server: " + request.toString(), 100);
                    this.displayDebug("Body received: " + sbHttpResponseBody.toString(), 100);
                    throw throwable;
                }
            }
        }
    }

    public void setProperty(String prop, String value) throws JUploadException {
        if (prop.equals("afterUploadURL")) {
            this.setAfterUploadURL(value);
        } else if (prop.equals("allowHttpPersistent")) {
            this.setAllowHttpPersistent(Boolean.parseBoolean(value));
        } else if (prop.equals("allowedFileExtensions")) {
            this.setAllowedFileExtensions(value);
        } else if (prop.equals("debugLevel")) {
            this.setDebugLevel(UploadPolicyFactory.parseInt(value, this.debugLevel, this));
        } else if (prop.equals("fileChooserIconFromFileContent")) {
            this.setFileChooserIconFromFileContent(UploadPolicyFactory.parseInt(value, this.getFileChooserIconFromFileContent(), this));
        } else if (prop.equals("fileChooserIconSize")) {
            this.setFileChooserIconSize(UploadPolicyFactory.parseInt(value, this.getFileChooserIconSize(), this));
        } else if (prop.equals("lang")) {
            this.setLang(value);
        } else if (prop.equals("filenameEncoding")) {
            this.setFilenameEncoding(value);
        } else if (prop.equals("lookAndFeel")) {
            this.setLookAndFeel(value);
        } else if (prop.equals("maxChunkSize")) {
            this.setMaxChunkSize(UploadPolicyFactory.parseLong(value, this.maxChunkSize, this));
        } else if (prop.equals("maxFileSize")) {
            this.setMaxFileSize(UploadPolicyFactory.parseLong(value, this.maxFileSize, this));
        } else if (prop.equals("nbFilesPerRequest")) {
            this.setNbFilesPerRequest(UploadPolicyFactory.parseInt(value, this.nbFilesPerRequest, this));
        } else if (prop.equals("postURL")) {
            this.setPostURL(value);
        } else if (prop.equals("serverProtocol")) {
            this.setServerProtocol(value);
        } else if (prop.equals("stringUploadSuccess")) {
            this.setStringUploadSuccess(value);
        } else if (prop.equals("sslVerifyCert")) {
            this.setSslVerifyCert(value);
        } else if (prop.equals("urlToSendErrorTo")) {
            this.setUrlToSendErrorTo(value);
        } else {
            this.displayWarn("Unknown applet parameter: " + prop + " (in DefaultUploadPolicy.setProperty)");
        }
    }

    public void displayParameterStatus() {
        if (this.getDebugLevel() >= 20) {
            this.displayDebug("=======================================================================", 20);
            this.displayDebug("======= Parameters managed by DefaultUploadPolicy", 20);
            this.displayInfo("JUpload applet, version " + JUploadApplet.VERSION + " (compiled: " + JUploadApplet.BUILD_DATE + "), available at http://jupload.sourceforge.net/");
            this.displayDebug("Java version: " + System.getProperty("java.version"), 20);
            this.displayDebug("Cookie: " + this.cookie, 20);
            this.displayDebug("userAgent: " + this.userAgent, 20);
            this.displayDebug("List of all applet parameters:", 20);
            this.displayDebug("  language: " + this.resourceBundle.getLocale().getLanguage(), 20);
            this.displayDebug("  country: " + this.resourceBundle.getLocale().getCountry(), 20);
            this.displayDebug("afterUploadURL: " + this.getAfterUploadURL(), 20);
            this.displayDebug("allowHttpPersistent: " + this.getAllowHttpPersistent(), 20);
            this.displayDebug("allowedFileExtensions: " + this.getAllowedFileExtensions(), 20);
            this.displayDebug("debugLevel: " + this.debugLevel + " (debugfile: " + this.debugFile.getAbsolutePath() + ")", 1);
            this.displayDebug("fileChooserIconFromFileContent: " + this.getFileChooserIconFromFileContent(), 20);
            this.displayDebug("fileChooserIconSize: " + this.getFileChooserIconSize(), 20);
            this.displayDebug("filenameEncoding: " + this.getFilenameEncoding(), 20);
            this.displayDebug("lang: " + this.lang, 20);
            this.displayDebug("maxChunkSize: " + this.getMaxChunkSize(), 20);
            if (this.maxFileSize == Long.MAX_VALUE) {
                this.displayDebug("maxFileSize: " + this.getMaxFileSize(), 20);
            } else {
                this.displayInfo("maxFileSize: " + this.getMaxFileSize());
            }
            this.displayDebug("nbFilesPerRequest: " + this.getNbFilesPerRequest(), 20);
            this.displayDebug("postURL: " + this.postURL, 20);
            this.displayDebug("serverProtocol: " + this.getServerProtocol(), 20);
            this.displayDebug("showLogWindow: " + this.getShowLogWindow(), 20);
            this.displayDebug("showStatusbar: " + this.showStatusbar, 20);
            this.displayDebug("specificHeaders: " + this.getSpecificHeaders(), 20);
            this.displayDebug("stringUploadSuccess: " + this.getStringUploadSuccess(), 20);
            this.displayDebug("stringUploadError: " + this.getStringUploadError(), 20);
            this.displayDebug("urlToSendErrorTo: " + this.getUrlToSendErrorTo(), 20);
            this.displayDebug("", 20);
        }
    }

    private final String normalizeURL(String url) throws JUploadException {
        if (null == url || url.length() == 0) {
            return this.getApplet().getDocumentBase().toString();
        }
        URI uri = null;
        try {
            uri = new URI(url);
            if (null == uri.getScheme()) {
                uri = this.getApplet().getDocumentBase().toURI().resolve(url);
            }
            if (!(uri.getScheme().equals("http") || uri.getScheme().equals("https") || uri.getScheme().equals("ftp"))) {
                throw new JUploadException("URI scheme " + uri.getScheme() + " not supported.");
            }
        }
        catch (URISyntaxException e) {
            throw new JUploadException(e);
        }
        return uri.toString();
    }

    public String getAfterUploadURL() {
        return this.afterUploadURL;
    }

    protected void setAfterUploadURL(String afterUploadURL) throws JUploadException {
        if (null == afterUploadURL) {
            return;
        }
        this.afterUploadURL = afterUploadURL.toLowerCase().startsWith("javascript:") ? afterUploadURL : this.normalizeURL(afterUploadURL);
    }

    public boolean getAllowHttpPersistent() {
        return this.allowHttpPersistent;
    }

    public String getAllowedFileExtensions() {
        return this.allowedFileExtensions;
    }

    protected void setAllowedFileExtensions(String allowedFileExtensions) {
        this.allowedFileExtensions = allowedFileExtensions == null || allowedFileExtensions.equals("") ? null : (allowedFileExtensions.startsWith("/") ? "" : "/") + allowedFileExtensions.toLowerCase() + (allowedFileExtensions.endsWith("/") ? "" : "/");
    }

    protected void setAllowHttpPersistent(boolean value) {
        this.allowHttpPersistent = value;
    }

    public JUploadApplet getApplet() {
        return this.applet;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(int debugLevel) {
        this.setDebugLevel(debugLevel, true);
    }

    public void setDebugLevel(int debugLevel, boolean displayAppletParameterList) {
        if (this.debugLevel >= 0) {
            this.displayInfo("Debug level set to " + debugLevel);
            this.displayInfo("Current debug output file: " + this.debugFile.getAbsolutePath());
        }
        this.debugLevel = debugLevel;
        if (this.getApplet().getUploadPanel() != null) {
            this.getApplet().getUploadPanel().showOrHideLogWindow();
            if (displayAppletParameterList) {
                this.displayParameterStatus();
            }
        }
    }

    public int getFileChooserIconFromFileContent() {
        return this.fileChooserIconFromFileContent;
    }

    public void setFileChooserIconFromFileContent(int fileChooserIconFromFileContent) {
        this.fileChooserIconFromFileContent = fileChooserIconFromFileContent;
    }

    public int getFileChooserIconSize() {
        return this.fileChooserIconSize;
    }

    public void setFileChooserIconSize(int fileChooserIconSize) {
        this.fileChooserIconSize = fileChooserIconSize;
    }

    protected void setLang(String lang) {
        Locale locale;
        this.lang = lang;
        if (lang == null) {
            this.displayInfo("lang = null, taking default language");
            locale = Locale.getDefault();
        } else if (lang.length() == 5 && (lang.substring(2, 3).equals("_") || lang.substring(2, 3).equals("-"))) {
            String language = lang.substring(0, 2);
            String country = lang.substring(3, 5);
            this.displayDebug("setLang - language read: " + language, 50);
            this.displayDebug("setLang - country read: " + country, 50);
            locale = new Locale(language, country.toUpperCase());
        } else {
            locale = new Locale(lang);
        }
        this.resourceBundle = ResourceBundle.getBundle("wjhk.jupload2.lang.lang", locale);
    }

    protected String getLookAndFeel() {
        return this.lookAndFeel;
    }

    protected void setLookAndFeel(String lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
        if (lookAndFeel != null && !lookAndFeel.equals("") && !lookAndFeel.equals("java")) {
            try {
                if (!lookAndFeel.equals("system")) {
                    UIManager.setLookAndFeel(lookAndFeel);
                } else {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
            catch (Exception e) {
                this.displayErr(e);
            }
        }
    }

    public long getMaxChunkSize() {
        return this.maxChunkSize;
    }

    protected void setMaxChunkSize(long maxChunkSize) {
        if (maxChunkSize < 0L) {
            this.displayDebug("maxChunkSize<0 which is invalid. Switched to the default value (Long.MAX_VALUE)", 1);
            maxChunkSize = Long.MAX_VALUE;
        }
        this.maxChunkSize = maxChunkSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    protected void setMaxFileSize(long maxFileSize) {
        if (maxFileSize < 0L) {
            this.displayDebug("maxFileSize<0 which is invalid. Switched to the default value (Long.MAX_VALUE)", 1);
            maxFileSize = Long.MAX_VALUE;
        }
        this.maxFileSize = maxFileSize;
    }

    public int getNbFilesPerRequest() {
        return this.nbFilesPerRequest;
    }

    protected void setNbFilesPerRequest(int nbFilesPerRequest) {
        if (nbFilesPerRequest < 0) {
            this.displayDebug("nbFilesPerRequest<0 which is invalid. Switched to the default value (Integer.MAX_VALUE)", 1);
            nbFilesPerRequest = Integer.MAX_VALUE;
        }
        this.nbFilesPerRequest = nbFilesPerRequest;
    }

    public String getFilenameEncoding() {
        return this.filenameEncoding;
    }

    protected void setFilenameEncoding(String filenameEncoding) {
        this.filenameEncoding = filenameEncoding;
    }

    public String getPostURL() {
        return this.postURL;
    }

    public void setPostURL(String postURL) throws JUploadException {
        this.postURL = this.normalizeURL(postURL);
    }

    public String getServerProtocol() {
        return this.serverProtocol;
    }

    protected void setServerProtocol(String value) throws JUploadException {
        if (null == value || value.equals("")) {
            if (null == this.postURL || this.postURL.equals("")) {
                this.displayErr("postURL not set");
                value = UploadPolicy.DEFAULT_SERVER_PROTOCOL;
            } else if (this.postURL.substring(0, 3).equals("ftp")) {
                value = "ftp";
            } else {
                try {
                    value = new HttpConnect(this).getProtocol();
                }
                catch (Exception e) {
                    this.displayErr("Unable to access to the postURL: '" + this.getPostURL() + "'", e);
                    value = UploadPolicy.DEFAULT_SERVER_PROTOCOL;
                }
            }
        }
        this.serverProtocol = value;
    }

    public boolean getShowLogWindow() {
        return this.showLogWindow;
    }

    protected void setShowLogWindow(boolean showLogWindow) {
        this.showLogWindow = showLogWindow;
        if (this.getApplet().getUploadPanel() != null) {
            this.getApplet().getUploadPanel().showOrHideLogWindow();
        }
    }

    public String getSpecificHeaders() {
        return this.specificHeaders;
    }

    protected void setSpecificHeaders(String specificHeaders) {
        this.specificHeaders = specificHeaders;
        if (specificHeaders != null) {
            String[] headerArray = specificHeaders.split("\\\\n");
            for (int x = 0; x < headerArray.length; ++x) {
                this.addHeader(headerArray[x]);
            }
        }
    }

    public int getSslVerifyCert() {
        return this.sslVerifyCert;
    }

    protected void setSslVerifyCert(String mode) throws JUploadException {
        int val = -1;
        if (mode.toLowerCase().equals("none")) {
            val = 0;
        }
        if (mode.toLowerCase().equals("server")) {
            val = 1;
        }
        if (mode.toLowerCase().equals("client")) {
            val = 2;
        }
        if (mode.toLowerCase().equals("strict")) {
            val = 3;
        }
        if (val == -1) {
            throw new JUploadException("Invalid parameter sslVerifyCert (" + mode + ")");
        }
        this.sslVerifyCert = val;
    }

    protected void setShowStatusbar(boolean show) {
        this.showStatusbar = show;
    }

    public String getStringUploadError() {
        return this.stringUploadError;
    }

    public String getStringUploadSuccess() {
        return this.stringUploadSuccess;
    }

    protected void setStringUploadError(String stringUploadError) throws JUploadException {
        this.stringUploadError = stringUploadError;
        try {
            this.patternError = Pattern.compile(stringUploadError);
        }
        catch (PatternSyntaxException e) {
            throw new JUploadException("Invalid regex in parameter stringUploadError");
        }
    }

    protected void setStringUploadSuccess(String stringUploadSuccess) throws JUploadException {
        this.stringUploadSuccess = stringUploadSuccess;
        try {
            this.patternSuccess = Pattern.compile(stringUploadSuccess);
        }
        catch (PatternSyntaxException e) {
            throw new JUploadException("Invalid regex in parameter stringUploadSuccess");
        }
    }

    public String getUrlToSendErrorTo() {
        return this.urlToSendErrorTo;
    }

    protected void setUrlToSendErrorTo(String urlToSendErrorTo) throws JUploadException {
        if (null == urlToSendErrorTo) {
            return;
        }
        String tmp = this.normalizeURL(urlToSendErrorTo);
        if (tmp.startsWith("ftp://")) {
            throw new JUploadException("urlToSendErrorTo: ftp scheme not supported.");
        }
        this.urlToSendErrorTo = tmp;
    }

    public String getFormdata() {
        return this.formData;
    }

    public String getAfterUploadTarget() {
        return this.afterUploadTarget;
    }

    public Cursor setWaitCursor() {
        Cursor previousCursor = this.getApplet().getCursor();
        this.getApplet().setCursor(new Cursor(3));
        return previousCursor;
    }

    public void setCursor(Cursor cursor) {
        this.getApplet().setCursor(cursor);
    }

    public void deleteLog() {
        try {
            if (null != this.debugOut) {
                this.debugOut.close();
                this.debugOut = null;
            }
            if (null != this.debugFile) {
                this.debugFile.delete();
                this.debugFile = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addMsgToDebugLog(String msg) {
        block6: {
            if (this.debugOk) {
                try {
                    if (null == this.debugOut) {
                        this.getApplet().registerUnload(this, "deleteLog");
                        this.debugFile = File.createTempFile("jupload_", "_log.txt");
                        this.debugOut = new PrintStream(new FileOutputStream(this.debugFile));
                    }
                    boolean endsLF = msg.endsWith("\n");
                    msg = msg.replaceAll("\n", CRLF);
                    if (endsLF) {
                        this.debugOut.print(msg);
                        break block6;
                    }
                    this.debugOut.println(msg);
                }
                catch (IOException e) {
                    this.debugOk = false;
                    System.err.println("IO error on debuglog " + this.debugFile.getPath() + "\nFallback to standard output.");
                    System.out.println(msg);
                }
            } else {
                System.out.println(msg);
            }
        }
    }

    private final String timestamp(String tag, String s) {
        String stamp = new SimpleDateFormat("HH:mm:ss.SSS ").format(new Date()) + tag;
        boolean endsLF = s.endsWith("\n");
        if (endsLF) {
            s = s.substring(0, s.length() - 1);
        }
        return stamp + s.replaceAll("\n", "\n" + stamp) + (endsLF ? "\n" : "");
    }

    private synchronized void displayMsg(String tag, String msg) {
        msg = this.timestamp(tag, msg);
        if (this.logWindow == null) {
            System.out.println(msg);
        } else {
            int lc;
            this.logWindow.append(msg);
            if (!msg.endsWith("\n")) {
                this.logWindow.append("\n");
            }
            if ((lc = this.logWindow.getLineCount()) > 10000) {
                try {
                    int end = this.logWindow.getLineEndOffset(lc - 10000);
                    this.logWindow.replaceRange("", 0, end);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
        this.addMsgToDebugLog(msg);
    }

    public void afterFileDropped(DropTargetDropEvent dropEvent) {
    }

    public JUploadFileChooser createFileChooser() {
        return new JUploadFileChooser(this);
    }

    public boolean fileFilterAccept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (this.allowedFileExtensions == null || this.allowedFileExtensions.equals("")) {
            return true;
        }
        String extension = DefaultFileData.getExtension(file).toLowerCase();
        return this.allowedFileExtensions.indexOf("/" + extension + "/") >= 0;
    }

    public String fileFilterGetDescription() {
        if (this.allowedFileExtensions == null || this.allowedFileExtensions.equals("")) {
            return null;
        }
        return "JUpload file filter (" + this.allowedFileExtensions + ")";
    }

    public Icon fileViewGetIcon(File file) {
        return null;
    }

    public String getLastResponseBody() {
        return null != this.lastResponseBody ? this.lastResponseBody : "";
    }

    public String getLastResponseMessage() {
        return null != this.lastResponseMessage ? this.lastResponseMessage : "";
    }
}

