/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui;

import java.awt.Container;
import java.awt.Frame;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import wjhk.jupload2.JUploadApplet;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.gui.DnDListener;
import wjhk.jupload2.gui.FilePanel;
import wjhk.jupload2.gui.FilePanelTableImp;
import wjhk.jupload2.gui.JUploadFileChooser;
import wjhk.jupload2.gui.JUploadPopupMenu;
import wjhk.jupload2.gui.JUploadTextArea;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.FileUploadThread;
import wjhk.jupload2.upload.FileUploadThreadFTP;
import wjhk.jupload2.upload.FileUploadThreadHTTP;

public class JUploadPanel
extends JPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = -1212601012568225757L;
    private static final double gB = 1.073741824E9;
    private static final double mB = 1048576.0;
    private static final double kB = 1024.0;
    private JUploadPopupMenu jUploadPopupMenu;
    private static final int DEFAULT_TIMEOUT = 100;
    private static final int PROGRESS_INTERVAL = 10;
    private int update_counter = 0;
    private DnDListener dndListener = null;
    private JButton browseButton = null;
    private JButton removeButton = null;
    private JButton removeAllButton = null;
    private JButton uploadButton = null;
    private JButton stopButton = null;
    private JUploadFileChooser fileChooser = null;
    private FilePanel filePanel = null;
    private JProgressBar progressBar = null;
    private JLabel statusLabel = null;
    private JUploadTextArea logWindow = null;
    private JScrollPane jLogWindowPane = null;
    private Timer timerUpload = new Timer(100, this);
    private Timer timerAfterUpload = new Timer(5000, this);
    private UploadPolicy uploadPolicy = null;
    protected FileUploadThread fileUploadThread = null;

    public JUploadPanel(Container containerParam, JUploadTextArea logWindow, UploadPolicy uploadPolicyParam) throws Exception {
        this.logWindow = logWindow;
        this.uploadPolicy = uploadPolicyParam;
        this.jUploadPopupMenu = new JUploadPopupMenu(this.uploadPolicy);
        this.createStandardComponents();
        logWindow.addMouseListener(this);
        this.uploadPolicy.addComponentsToJUploadPanel(this);
        this.dndListener = new DnDListener(this, this.uploadPolicy);
        new DropTarget(this, this.dndListener);
        new DropTarget(this.filePanel.getDropComponent(), this.dndListener);
        new DropTarget(this.logWindow, this.dndListener);
        this.browseButton.addMouseListener(this);
        this.removeAllButton.addMouseListener(this);
        this.removeButton.addMouseListener(this);
        this.stopButton.addMouseListener(this);
        this.uploadButton.addMouseListener(this);
        this.jLogWindowPane.addMouseListener(this);
        logWindow.addMouseListener(this);
        this.progressBar.addMouseListener(this);
        this.statusLabel.addMouseListener(this);
        try {
            this.fileChooser = uploadPolicyParam.createFileChooser();
        }
        catch (Exception e) {
            this.uploadPolicy.displayErr(e);
        }
    }

    private void createStandardComponents() {
        if (this.browseButton == null) {
            this.browseButton = new JButton(this.uploadPolicy.getString("buttonBrowse"));
            this.browseButton.setIcon(new ImageIcon(this.getClass().getResource("/images/explorer.gif")));
        }
        this.browseButton.addActionListener(this);
        if (this.removeButton == null) {
            this.removeButton = new JButton(this.uploadPolicy.getString("buttonRemoveSelected"));
            this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/images/recycle.gif")));
        }
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        if (this.removeAllButton == null) {
            this.removeAllButton = new JButton(this.uploadPolicy.getString("buttonRemoveAll"));
            this.removeAllButton.setIcon(new ImageIcon(this.getClass().getResource("/images/cross.gif")));
        }
        this.removeAllButton.setEnabled(false);
        this.removeAllButton.addActionListener(this);
        if (null == this.uploadButton) {
            this.uploadButton = new JButton(this.uploadPolicy.getString("buttonUpload"));
            this.uploadButton.setIcon(new ImageIcon(this.getClass().getResource("/images/up.gif")));
        }
        this.uploadButton.setEnabled(false);
        this.uploadButton.addActionListener(this);
        this.filePanel = new FilePanelTableImp(this, this.uploadPolicy);
        if (null == this.progressBar) {
            this.progressBar = new JProgressBar(0);
            this.progressBar.setStringPainted(true);
        }
        if (null == this.stopButton) {
            this.stopButton = new JButton(this.uploadPolicy.getString("buttonStop"));
            this.stopButton.setIcon(new ImageIcon(this.getClass().getResource("/images/cross.gif")));
        }
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(this);
        if (this.jLogWindowPane == null) {
            this.jLogWindowPane = new JScrollPane();
            this.jLogWindowPane.setVerticalScrollBarPolicy(22);
            this.jLogWindowPane.setHorizontalScrollBarPolicy(31);
        }
        this.jLogWindowPane.getViewport().add(this.logWindow);
        this.jLogWindowPane.setPreferredSize(null);
        this.statusLabel = new JLabel("JUpload V" + JUploadApplet.VERSION);
    }

    public void showOrHideLogWindow() {
        if (this.uploadPolicy.getShowLogWindow() || this.uploadPolicy.getDebugLevel() > 0) {
            this.jLogWindowPane.setVisible(true);
        } else {
            this.jLogWindowPane.setVisible(false);
        }
        this.validate();
    }

    protected void addFiles(File[] f, File root) {
        this.filePanel.addFiles(f, root);
        if (0 < this.filePanel.getFilesLength()) {
            this.removeButton.setEnabled(true);
            this.removeAllButton.setEnabled(true);
            this.uploadButton.setEnabled(true);
        }
    }

    private void actionPerformedTimerExpired() {
        this.update_counter = 0;
        if (null != this.progressBar && this.fileUploadThread.getStartTime() != 0L) {
            String eta;
            double cps;
            double percent;
            long duration = (System.currentTimeMillis() - this.fileUploadThread.getStartTime()) / 1000L;
            double done = this.fileUploadThread.getUploadedLength();
            double total = this.fileUploadThread.getTotalLength();
            try {
                percent = 100.0 * done / total;
            }
            catch (ArithmeticException e1) {
                percent = 100.0;
            }
            try {
                cps = done / (double)duration;
            }
            catch (ArithmeticException e1) {
                cps = done;
            }
            try {
                long remaining = (long)((total - done) / cps);
                eta = remaining > 3600L ? String.format(this.uploadPolicy.getString("timefmt_hms"), new Long(remaining / 3600L), new Long(remaining / 60L % 60L), new Long(remaining % 60L)) : (remaining > 60L ? String.format(this.uploadPolicy.getString("timefmt_ms"), new Long(remaining / 60L), new Long(remaining % 60L)) : String.format(this.uploadPolicy.getString("timefmt_s"), new Long(remaining)));
            }
            catch (ArithmeticException e1) {
                eta = this.uploadPolicy.getString("timefmt_unknown");
            }
            this.progressBar.setValue((int)percent);
            String unit = this.uploadPolicy.getString("speedunit_b_per_second");
            if (cps >= 1.073741824E9) {
                cps /= 1.073741824E9;
                unit = this.uploadPolicy.getString("speedunit_gb_per_second");
            } else if (cps >= 1048576.0) {
                cps /= 1048576.0;
                unit = this.uploadPolicy.getString("speedunit_mb_per_second");
            } else if (cps >= 1024.0) {
                cps /= 1024.0;
                unit = this.uploadPolicy.getString("speedunit_kb_per_second");
            }
            String status = String.format(this.uploadPolicy.getString("status_msg"), new Integer((int)percent), new Double(cps), unit, eta);
            this.statusLabel.setText(status);
            this.uploadPolicy.getApplet().getAppletContext().showStatus(status);
        }
    }

    private void actionPerformedUploadFinished() {
        this.uploadPolicy.displayDebug("JUploadPanel: after !fileUploadThread.isAlive()", 60);
        this.timerUpload.stop();
        String svrRet = this.fileUploadThread.getResponseMsg();
        Exception ex = this.fileUploadThread.getException();
        this.stopButton.setEnabled(false);
        this.browseButton.setEnabled(true);
        this.fileUploadThread.close();
        this.fileUploadThread = null;
        try {
            this.uploadPolicy.afterUpload(ex, svrRet);
        }
        catch (JUploadException e1) {
            this.uploadPolicy.displayErr("error in uploadPolicy.afterUpload (JUploadPanel)", e1);
        }
        boolean haveFiles = 0 < this.filePanel.getFilesLength();
        this.uploadButton.setEnabled(haveFiles);
        this.removeButton.setEnabled(haveFiles);
        this.removeAllButton.setEnabled(haveFiles);
        this.uploadPolicy.getApplet().getAppletContext().showStatus("");
        this.statusLabel.setText(" ");
        this.timerAfterUpload.start();
    }

    private void actionClearProgressBar() {
        this.progressBar.setValue(0);
        this.progressBar.setString(null);
        this.timerAfterUpload.stop();
    }

    public void doBrowse() {
        if (null != this.fileChooser) {
            try {
                int ret = this.fileChooser.showOpenDialog(new Frame());
                if (0 == ret) {
                    this.addFiles(this.fileChooser.getSelectedFiles(), this.fileChooser.getCurrentDirectory());
                }
                this.fileChooser.shutdownNow();
            }
            catch (Exception ex) {
                this.uploadPolicy.displayErr(ex);
            }
        }
    }

    public void doRemove() {
        this.filePanel.removeSelected();
        if (0 >= this.filePanel.getFilesLength()) {
            this.removeButton.setEnabled(false);
            this.removeAllButton.setEnabled(false);
            this.uploadButton.setEnabled(false);
        }
    }

    public void doRemoveAll() {
        this.filePanel.removeAll();
        this.removeButton.setEnabled(false);
        this.removeAllButton.setEnabled(false);
        this.uploadButton.setEnabled(false);
    }

    public void doStartUpload() {
        if (this.uploadPolicy.isUploadReady()) {
            this.uploadPolicy.beforeUpload();
            this.browseButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.removeAllButton.setEnabled(false);
            this.uploadButton.setEnabled(false);
            this.stopButton.setEnabled(true);
            if (this.uploadPolicy.getPostURL().substring(0, 4).equals("ftp:")) {
                try {
                    this.fileUploadThread = new FileUploadThreadFTP(this.filePanel.getFiles(), this.uploadPolicy, this.progressBar);
                }
                catch (JUploadException e1) {
                    this.uploadPolicy.displayErr(e1);
                }
            } else {
                this.fileUploadThread = new FileUploadThreadHTTP(this.filePanel.getFiles(), this.uploadPolicy, this.progressBar);
            }
            this.fileUploadThread.start();
            this.timerUpload.start();
            this.uploadPolicy.displayDebug("Timer started", 60);
        }
    }

    public void doStopUpload() {
        this.fileUploadThread.stopUpload();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof Timer) {
            if (this.timerUpload.isRunning()) {
                if (this.update_counter++ > 10 || !this.fileUploadThread.isAlive()) {
                    this.actionPerformedTimerExpired();
                }
                if (!this.fileUploadThread.isAlive()) {
                    this.actionPerformedUploadFinished();
                }
            } else if (this.timerAfterUpload.isRunning()) {
                this.actionClearProgressBar();
            }
            return;
        }
        this.uploadPolicy.displayDebug("Action : " + e.getActionCommand(), 1);
        if (e.getActionCommand() == this.browseButton.getActionCommand()) {
            this.doBrowse();
        } else if (e.getActionCommand() == this.removeButton.getActionCommand()) {
            this.doRemove();
        } else if (e.getActionCommand() == this.removeAllButton.getActionCommand()) {
            this.doRemoveAll();
        } else if (e.getActionCommand() == this.uploadButton.getActionCommand()) {
            this.doStartUpload();
        } else if (e.getActionCommand() == this.stopButton.getActionCommand()) {
            this.doStopUpload();
        }
        this.filePanel.focusTable();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.maybeOpenPopupMenu(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.maybeOpenPopupMenu(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.maybeOpenPopupMenu(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeOpenPopupMenu(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.uploadPolicy.onFileDoubleClicked(this.filePanel.getFileDataAt(mouseEvent.getPoint()));
        } else {
            this.maybeOpenPopupMenu(mouseEvent);
        }
    }

    boolean maybeOpenPopupMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && (mouseEvent.getModifiersEx() & 0x80) == 128 && this.jUploadPopupMenu != null) {
            this.jUploadPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            return true;
        }
        return false;
    }

    public JButton getBrowseButton() {
        return this.browseButton;
    }

    public DnDListener getDndListener() {
        return this.dndListener;
    }

    public FilePanel getFilePanel() {
        return this.filePanel;
    }

    public JScrollPane getJLogWindowPane() {
        return this.jLogWindowPane;
    }

    protected JUploadTextArea getLogWindow() {
        return this.logWindow;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public JButton getRemoveAllButton() {
        return this.removeAllButton;
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    public JLabel getStatusLabel() {
        return this.statusLabel;
    }

    public JButton getStopButton() {
        return this.stopButton;
    }

    public JButton getUploadButton() {
        return this.uploadButton;
    }

    public void setFilePanel(FilePanel filePanel) {
        this.filePanel = filePanel;
    }
}

