/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import wjhk.jupload2.gui.LoadImageThread;
import wjhk.jupload2.policies.UploadPolicy;

public class JUploadImagePreview
extends JComponent
implements PropertyChangeListener {
    private static final long serialVersionUID = -6882108570945459638L;
    UploadPolicy uploadPolicy;
    JFileChooser jFileChooser = null;
    ImageIcon thumbnail = null;
    File file = null;
    LoadImageThread loadImageThread = null;

    public JUploadImagePreview(JFileChooser jFileChooser, UploadPolicy uploadPolicy) {
        this.jFileChooser = jFileChooser;
        this.uploadPolicy = uploadPolicy;
        this.setPreferredSize(new Dimension(200, 200));
        jFileChooser.addPropertyChangeListener(this);
    }

    void setThumbnail(ImageIcon thumbnail) {
        this.thumbnail = thumbnail;
        this.repaint();
    }

    void setFile(File fileParam) {
        this.file = fileParam != null && fileParam.isDirectory() ? null : fileParam;
        this.thumbnail = null;
        this.repaint();
        if (this.loadImageThread != null && this.loadImageThread.isAlive()) {
            this.loadImageThread.interrupt();
            this.loadImageThread = null;
        }
        if (this.file != null) {
            this.loadImageThread = new LoadImageThread(this, this.file);
            this.loadImageThread.setPriority(10);
            this.loadImageThread.start();
            this.repaint();
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.setFile(null);
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.setFile((File)e.getNewValue());
        }
    }

    protected void paintComponent(Graphics g) {
        if (this.thumbnail != null) {
            int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (y < 0) {
                y = 0;
            }
            if (x < 5) {
                x = 5;
            }
            this.thumbnail.paintIcon(this, g, x, y);
            this.uploadPolicy.displayDebug("JUploadImagePreview.paintComponent, after paintIcon", 100);
        }
    }
}

