/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.filedata;

import java.awt.AlphaComposite;
import java.awt.Canvas;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.filedata.DefaultFileData;
import wjhk.jupload2.policies.PictureUploadPolicy;

public class PictureFileData
extends DefaultFileData {
    private boolean isPicture = false;
    boolean storeBufferedImage = false;
    private Image offscreenImage = null;
    int quarterRotation = 0;
    int originalWidth = -1;
    int originalHeight = -1;
    private File transformedPictureFile = null;
    private long uploadLength = -1L;
    private Boolean hasToTransformPicture = null;

    public PictureFileData(File file, File root, PictureUploadPolicy uploadPolicy) {
        super(file, root, uploadPolicy);
        this.storeBufferedImage = uploadPolicy.hasToStoreBufferedImage();
        String fileExtension = this.getFileExtension();
        Iterator<ImageReader> iter = ImageIO.getImageReadersByFormatName(fileExtension);
        this.isPicture = iter.hasNext();
        uploadPolicy.displayDebug("isPicture=" + this.isPicture + " (" + file.getName() + "), extension=" + fileExtension, 75);
        if (this.isPicture) {
            this.setMimeTypeByExtension(fileExtension);
        }
    }

    public void freeMemory(String caller) {
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        this.uploadPolicy.displayDebug("freeMemory (after " + caller + ") : " + rt.freeMemory(), 80);
    }

    public void beforeUpload() throws JUploadException {
        if (this.uploadLength < 0L) {
            try {
                if (this.hasToTransformPicture()) {
                    this.getTransformedPictureFile();
                } else if (!((PictureUploadPolicy)this.uploadPolicy).getPictureTransmitMetadata()) {
                    this.clearPictureFileMetadata();
                }
            }
            catch (OutOfMemoryError e) {
                this.deleteTransformedPictureFile();
                this.tooBigPicture();
            }
            this.uploadLength = this.transformedPictureFile != null ? this.transformedPictureFile.length() : this.getFile().length();
        }
        super.beforeUpload();
    }

    public long getUploadLength() throws JUploadException {
        if (this.uploadLength < 0L) {
            this.beforeUpload();
        }
        return this.uploadLength;
    }

    public InputStream getInputStream() throws JUploadException {
        if (this.transformedPictureFile != null) {
            try {
                return new FileInputStream(this.transformedPictureFile);
            }
            catch (FileNotFoundException e) {
                throw new JUploadIOException(e);
            }
        }
        return super.getInputStream();
    }

    public void afterUpload() {
        super.afterUpload();
        if (this.transformedPictureFile != null) {
            if (this.uploadPolicy.getDebugLevel() >= 100) {
                this.uploadPolicy.displayWarn("Temporary file not deleted");
            } else {
                this.deleteTransformedPictureFile();
                this.uploadLength = -1L;
            }
        }
    }

    public Image getImage(Canvas canvas, boolean shadow) throws JUploadException {
        Image localImage = null;
        if (canvas == null) {
            throw new JUploadException("canvas null in PictureFileData.getImage");
        }
        int canvasWidth = canvas.getWidth();
        int canvasHeight = canvas.getHeight();
        if (canvasWidth <= 0 || canvasHeight <= 0) {
            this.uploadPolicy.displayDebug("canvas width and/or height null in PictureFileData.getImage()", 1);
        } else if (shadow && this.offscreenImage != null) {
            localImage = this.offscreenImage;
        } else if (this.isPicture) {
            try {
                localImage = this.getBufferedImage(canvasWidth, canvasHeight, ((PictureUploadPolicy)this.uploadPolicy).getHighQualityPreview());
            }
            catch (OutOfMemoryError e) {
                localImage = null;
                this.tooBigPicture();
            }
        }
        if (shadow) {
            this.offscreenImage = localImage;
        }
        this.freeMemory("end of " + this.getClass().getName() + ".getImage()");
        return localImage;
    }

    public void addRotation(int quarter) {
        this.quarterRotation += quarter;
        this.uploadLength = -1L;
        this.hasToTransformPicture = null;
        while (this.quarterRotation < 0) {
            this.quarterRotation += 4;
        }
        while (this.quarterRotation >= 4) {
            this.quarterRotation -= 4;
        }
        if (this.offscreenImage != null) {
            this.offscreenImage.flush();
            this.offscreenImage = null;
        }
    }

    public boolean isPicture() {
        return this.isPicture;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    private BufferedImage getBufferedImage(int maxWidth, int maxHeight, boolean highquality) throws JUploadException {
        BufferedImage bufferedImage = null;
        if (!this.isPicture) {
            bufferedImage = null;
        } else if (bufferedImage == null) {
            this.freeMemory("start of getBufferedImage");
            try {
                float scaleHeight;
                float scaleWidth;
                float scale;
                BufferedImage localBufferedImage = ImageIO.read(this.getFile());
                AffineTransform transform = new AffineTransform();
                this.originalWidth = localBufferedImage.getWidth();
                this.originalHeight = localBufferedImage.getHeight();
                int nonScaledRotatedWidth = this.originalWidth;
                int nonScaledRotatedHeight = this.originalHeight;
                if (this.quarterRotation % 2 != 0) {
                    nonScaledRotatedWidth = this.originalHeight;
                    nonScaledRotatedHeight = this.originalWidth;
                }
                if ((scale = Math.min(scaleWidth = maxWidth < 0 ? 1.0f : (float)maxWidth / (float)nonScaledRotatedWidth, scaleHeight = maxHeight < 0 ? 1.0f : (float)maxHeight / (float)nonScaledRotatedHeight)) < 1.0f && (maxWidth > 0 && maxWidth < (int)(scale * (float)nonScaledRotatedWidth) || maxHeight > 0 && maxHeight < (int)(scale * (float)nonScaledRotatedHeight))) {
                    scaleWidth = maxWidth < 0 ? 1.0f : (float)maxWidth / (float)(nonScaledRotatedWidth - 1);
                    scaleHeight = maxHeight < 0 ? 1.0f : (float)maxHeight / (float)(nonScaledRotatedHeight - 1);
                    scale = Math.min(scaleWidth, scaleHeight);
                }
                int scaledWidth = nonScaledRotatedWidth;
                int scaledHeight = nonScaledRotatedHeight;
                if (scale < 1.0f) {
                    scaledWidth = (int)((float)scaledWidth * scale);
                    scaledHeight = (int)((float)scaledHeight * scale);
                }
                if (this.quarterRotation != 0) {
                    double theta = Math.toRadians(90 * this.quarterRotation);
                    double translationX = 0.0;
                    double translationY = 0.0;
                    this.uploadPolicy.displayDebug("quarter: " + this.quarterRotation, 30);
                    switch (this.quarterRotation) {
                        case 1: {
                            translationX = 0.0;
                            translationY = -scaledWidth;
                            break;
                        }
                        case 2: {
                            translationX = -scaledWidth;
                            translationY = -scaledHeight;
                            break;
                        }
                        case 3: {
                            translationX = -scaledHeight;
                            translationY = 0.0;
                            break;
                        }
                        default: {
                            this.uploadPolicy.displayWarn("Invalid quarterRotation : " + this.quarterRotation);
                            this.quarterRotation = 0;
                            theta = 0.0;
                        }
                    }
                    transform.rotate(theta);
                    transform.translate(translationX, translationY);
                }
                if (scale < 1.0f) {
                    if (highquality) {
                        // empty if block
                    }
                    this.uploadPolicy.displayDebug("Resizing picture(using standard quality picture)", 40);
                    transform.scale(scale, scale);
                }
                if (transform.isIdentity()) {
                    bufferedImage = localBufferedImage;
                } else {
                    AffineTransformOp affineTransformOp = null;
                    affineTransformOp = new AffineTransformOp(transform, 1);
                    bufferedImage = affineTransformOp.createCompatibleDestImage(localBufferedImage, null);
                    this.uploadPolicy.displayDebug("bufferedImage.getColorModel(): " + bufferedImage.getColorModel().toString(), 80);
                    this.uploadPolicy.displayDebug("localBufferedImage.getColorModel(): " + localBufferedImage.getColorModel().toString(), 80);
                    affineTransformOp.filter(localBufferedImage, bufferedImage);
                    affineTransformOp = null;
                    bufferedImage.flush();
                }
                localBufferedImage.flush();
                localBufferedImage = null;
                transform = null;
                this.freeMemory("end of getBufferedImage");
            }
            catch (Exception e) {
                throw new JUploadException(e.getClass().getName() + " (createBufferedImage) : " + e.getMessage());
            }
            if (bufferedImage != null && this.uploadPolicy.getDebugLevel() >= 60) {
                this.uploadPolicy.displayDebug("bufferedImage MinX (" + bufferedImage + "): " + bufferedImage.getMinX(), 60);
                this.uploadPolicy.displayDebug("bufferedImage MinY (" + bufferedImage + "): " + bufferedImage.getMinY(), 60);
                this.uploadPolicy.displayDebug("bufferedImage Width (" + bufferedImage + "): " + bufferedImage.getWidth(), 60);
                this.uploadPolicy.displayDebug("bufferedImage Height (" + bufferedImage + "): " + bufferedImage.getHeight(), 60);
            }
        }
        return bufferedImage;
    }

    private boolean hasToTransformPicture() throws JUploadException {
        if (this.hasToTransformPicture == null) {
            int maxHeight;
            int maxWidth;
            int rotatedHeight;
            int rotatedWidth;
            if (!this.isPicture) {
                this.hasToTransformPicture = Boolean.FALSE;
            }
            if (this.hasToTransformPicture == null && this.quarterRotation != 0) {
                this.uploadPolicy.displayDebug(this.getFileName() + " : hasToTransformPicture = true (quarterRotation != 0)", 20);
                this.hasToTransformPicture = Boolean.TRUE;
            }
            if (this.hasToTransformPicture == null && ((PictureUploadPolicy)this.uploadPolicy).getTargetPictureFormat() != null) {
                String target = ((PictureUploadPolicy)this.uploadPolicy).getTargetPictureFormat().toLowerCase();
                String ext = this.getFileExtension().toLowerCase();
                if (target.equals("jpg")) {
                    target = "jpeg";
                }
                if (ext.equals("jpg")) {
                    ext = "jpeg";
                }
                if (!target.equals(ext)) {
                    this.uploadPolicy.displayDebug(this.getFileName() + " : hasToTransformPicture = true (targetPictureFormat)", 20);
                    this.hasToTransformPicture = Boolean.TRUE;
                }
            }
            if (this.hasToTransformPicture == null && (this.originalWidth < 0 || this.originalHeight < 0)) {
                try {
                    BufferedImage originalImage = ImageIO.read(this.getFile());
                    this.originalWidth = originalImage.getWidth();
                    this.originalHeight = originalImage.getHeight();
                    originalImage = null;
                    this.freeMemory("hasToTransformPicture");
                }
                catch (IOException e) {
                    throw new JUploadException("IOException in ImageIO.read (hasToTransformPicture) : " + e.getMessage());
                }
            }
            if (this.quarterRotation % 2 == 0) {
                rotatedWidth = this.originalWidth;
                rotatedHeight = this.originalHeight;
            } else {
                rotatedWidth = this.originalHeight;
                rotatedHeight = this.originalWidth;
            }
            if (this.quarterRotation == 0) {
                maxWidth = ((PictureUploadPolicy)this.uploadPolicy).getMaxWidth();
                maxHeight = ((PictureUploadPolicy)this.uploadPolicy).getMaxHeight();
            } else {
                maxWidth = ((PictureUploadPolicy)this.uploadPolicy).getRealMaxWidth();
                maxHeight = ((PictureUploadPolicy)this.uploadPolicy).getRealMaxHeight();
            }
            if (this.hasToTransformPicture == null && maxWidth > 0 && rotatedWidth > maxWidth) {
                this.uploadPolicy.displayDebug(this.getFileName() + " : hasToTransformPicture = true (rotatedWidth > maxWidth)", 20);
                this.hasToTransformPicture = Boolean.TRUE;
            }
            if (this.hasToTransformPicture == null && maxHeight > 0 && rotatedHeight > maxHeight) {
                this.uploadPolicy.displayDebug(this.getFileName() + " : hasToTransformPicture = true (rotatedHeight > maxHeight)", 20);
                this.hasToTransformPicture = Boolean.TRUE;
            }
            if (this.hasToTransformPicture == null) {
                this.uploadPolicy.displayDebug(this.getFileName() + " : hasToTransformPicture = false", 20);
                this.hasToTransformPicture = Boolean.FALSE;
            }
        }
        return this.hasToTransformPicture;
    }

    public void deleteTransformedPictureFile() {
        if (null != this.transformedPictureFile) {
            this.transformedPictureFile.delete();
            this.transformedPictureFile = null;
        }
    }

    private File getTransformedPictureFile() {
        BufferedImage bufferedImage = null;
        String tmpFileName = null;
        String action = null;
        if (this.transformedPictureFile == null) {
            try {
                action = "get temp file";
                this.transformedPictureFile = File.createTempFile("jupload_", ".tmp");
                if (this.transformedPictureFile.exists()) {
                    this.uploadPolicy.displayWarn("PictureFileData.getTransformedPictureFile(): temp file already exists " + this.transformedPictureFile.getAbsolutePath() + ")");
                }
                this.uploadPolicy.getApplet().registerUnload(this, "deleteTransformedPictureFile");
                tmpFileName = this.transformedPictureFile.getAbsolutePath();
                this.uploadPolicy.displayDebug("Using temp file " + tmpFileName + " for " + this.getFileName(), 50);
                action = "Temp file created";
                String localPictureFormat = ((PictureUploadPolicy)this.uploadPolicy).getTargetPictureFormat() == null ? this.getFileExtension() : ((PictureUploadPolicy)this.uploadPolicy).getTargetPictureFormat();
                bufferedImage = this.quarterRotation == 0 ? this.getBufferedImage(((PictureUploadPolicy)this.uploadPolicy).getMaxWidth(), ((PictureUploadPolicy)this.uploadPolicy).getMaxHeight(), true) : this.getBufferedImage(((PictureUploadPolicy)this.uploadPolicy).getRealMaxWidth(), ((PictureUploadPolicy)this.uploadPolicy).getRealMaxHeight(), true);
                action = "BufferedImage created";
                Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(localPictureFormat);
                if (iter.hasNext()) {
                    ImageWriter writer = iter.next();
                    ImageWriteParam iwp = writer.getDefaultWriteParam();
                    if (localPictureFormat.equalsIgnoreCase("jpg") || localPictureFormat.equalsIgnoreCase("jpeg")) {
                        iwp.setCompressionMode(2);
                        iwp.setCompressionQuality(((PictureUploadPolicy)this.uploadPolicy).getPictureCompressionQuality());
                    }
                    try {
                        this.uploadPolicy.displayDebug("ImageWriter1 (used), CompressionQuality=" + iwp.getCompressionQuality(), 95);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.uploadPolicy.displayInfo("Start of metadata managing, for " + this.getFileName());
                    IIOMetadata metadata = null;
                    action = "Should we transmit metadata ?";
                    if (((PictureUploadPolicy)this.uploadPolicy).getPictureTransmitMetadata()) {
                        Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(PictureFileData.getExtension(this.getFile()));
                        while (iterator.hasNext()) {
                            ImageReader ir = iterator.next();
                            try {
                                FileImageInputStream is = new FileImageInputStream(this.getFile());
                                ir.setInput(is);
                                metadata = ir.getImageMetadata(0);
                                this.uploadPolicy.displayDebug("Found one image reader that can read metadata!", 20);
                                break;
                            }
                            catch (Exception e) {
                                this.uploadPolicy.displayErr(e);
                            }
                        }
                        if (metadata == null) {
                            this.uploadPolicy.displayWarn("No metadata reader for " + this.getFileName());
                        }
                    }
                    action = "Creating FileImageOutputStream";
                    FileImageOutputStream output = new FileImageOutputStream(this.transformedPictureFile);
                    writer.setOutput(output);
                    action = "Writing IIOImage";
                    IIOImage image = new IIOImage(bufferedImage, null, metadata);
                    writer.write(null, image, iwp);
                    writer.dispose();
                    output.close();
                    output = null;
                    action = "IIOImage written";
                    int i = 2;
                    while (iter.hasNext()) {
                        this.uploadPolicy.displayDebug("ImageWriter" + i + " (not used)", 60);
                    }
                } else {
                    throw new JUploadException("No writer for the '" + localPictureFormat + "' picture format.");
                }
                action = "Finished";
                if (!this.storeBufferedImage) {
                    bufferedImage = null;
                    this.freeMemory("getTransformedPictureFile");
                }
                this.uploadPolicy.displayDebug("transformedPictureFile : " + this.transformedPictureFile.getName(), 30);
            }
            catch (Exception e) {
                this.uploadPolicy.displayWarn(e.getClass().getName() + " [" + e.getMessage() + "] " + " while writing the " + tmpFileName + " file. (picture will not be transformed) {action=" + action + "}");
                if (e instanceof FileNotFoundException) {
                    this.uploadPolicy.displayInfo(e.getClass().getName() + " probably means that the directory containing the picture is readonly: the applet can't write its temporary file.");
                }
                if (this.transformedPictureFile != null) {
                    try {
                        this.transformedPictureFile.delete();
                    }
                    catch (Exception e2) {
                        this.uploadPolicy.displayWarn(e2.getClass() + " while trying to remove temporary file (" + e2.getMessage() + ")");
                    }
                }
                this.transformedPictureFile = null;
            }
        }
        return this.transformedPictureFile;
    }

    private void tooBigPicture() {
        String msg = String.format(this.uploadPolicy.getString("tooBigPicture"), this.getFileName());
        JOptionPane.showMessageDialog(null, msg, "Warning", 2);
        this.uploadPolicy.displayWarn(msg);
    }

    private void setMimeTypeByExtension(String fileExtension) {
        String ext = fileExtension.toLowerCase();
        if (ext.equals("jpg")) {
            ext = "jpeg";
        }
        this.mimeType = "image/" + ext;
    }

    public static BufferedImage resizePicture(Image originalImage, int maxWidth, int maxHeight, boolean preserveAlpha, PictureUploadPolicy uploadPolicy) {
        int originalHeight;
        float heightScale;
        int originalWidth = originalImage.getWidth(uploadPolicy);
        float widthScale = (float)maxWidth / (float)originalWidth;
        double scale = Math.min(widthScale, heightScale = (float)maxHeight / (float)(originalHeight = originalImage.getHeight(uploadPolicy)));
        scale = scale > 1.0 ? 1.0 : scale;
        int scaledWidth = (int)(scale * (double)originalWidth);
        int scaledHeight = (int)(scale * (double)originalHeight);
        if (scaledWidth > maxWidth) {
            scaledWidth = maxWidth;
        }
        if (scaledHeight > maxHeight) {
            scaledHeight = maxHeight;
        }
        int imageType = preserveAlpha ? 1 : 2;
        BufferedImage scaledBI = new BufferedImage(scaledWidth, scaledHeight, imageType);
        Graphics2D g = scaledBI.createGraphics();
        if (preserveAlpha) {
            g.setComposite(AlphaComposite.Src);
        }
        g.drawImage(originalImage, 0, 0, scaledWidth, scaledHeight, null);
        g.dispose();
        return scaledBI;
    }

    public static ImageIcon getImageIcon(File pictureFile, int maxWidth, int maxHeight) {
        ImageIcon tmpIcon;
        ImageIcon thumbnail = null;
        if (pictureFile != null && (tmpIcon = new ImageIcon(pictureFile.getPath())) != null) {
            float scaleHeight;
            float scaleWidth = (float)maxWidth / (float)tmpIcon.getIconWidth();
            float scale = Math.min(scaleWidth, scaleHeight = (float)maxHeight / (float)tmpIcon.getIconHeight());
            thumbnail = scale < 1.0f ? new ImageIcon(tmpIcon.getImage().getScaledInstance((int)(scale * (float)tmpIcon.getIconWidth()), (int)(scale * (float)tmpIcon.getIconHeight()), 2)) : tmpIcon;
        }
        return thumbnail;
    }

    private void clearPictureFileMetadata() throws JUploadException {
        boolean metadataClearDone = false;
        try {
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("JPG");
            File outFile = this.transformedPictureFile != null ? this.transformedPictureFile : this.getFile();
            FileImageOutputStream output = new FileImageOutputStream(outFile);
            while (iter.hasNext()) {
                ImageWriter writer = iter.next();
                writer.setOutput(output);
                if (!writer.canReplaceImageMetadata(0)) continue;
                writer.replaceImageMetadata(0, null);
                metadataClearDone = true;
                break;
            }
        }
        catch (IOException ioe) {
            throw new JUploadException(ioe);
        }
        if (!metadataClearDone) {
            this.uploadPolicy.displayWarn("Image metada not cleared: will be transmitted with pictures");
        }
    }
}

